/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class InputToBinarySwitchU8<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    InputToBinary<GrayU8> alg;
    GrayU8 input;

    public InputToBinarySwitchU8(InputToBinary<GrayU8> alg, Class<T> inputType) {
        this.alg = alg;
        this.inputType = ImageType.single(inputType);
        if (this.inputType.getDataType() != ImageDataType.U8) {
            this.input = new GrayU8(1, 1);
        }
    }

    @Override
    public void process(T input, GrayU8 output) {
        if (this.input == null) {
            this.alg.process((GrayU8)input, output);
        } else {
            this.input.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, this.input);
            this.alg.process(this.input, output);
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }
}

