/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.binary.ComputeOtsu;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import java.util.Arrays;

public class ThresholdLocalOtsu
implements InputToBinary<GrayU8> {
    ImageType<GrayU8> imageType = ImageType.single(GrayU8.class);
    ComputeOtsu otsu;
    int[] histogram = new int[256];
    ConfigLength regionWidthLength;
    int regionWidth;
    int numPixels;

    public ThresholdLocalOtsu(boolean otsu2, ConfigLength regionWidthLength, double tuning, double scale, boolean down) {
        this.regionWidthLength = regionWidthLength;
        this.otsu = new ComputeOtsu(otsu2, tuning, down, scale);
    }

    @Override
    public void process(GrayU8 input, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int regionWidth = this.regionWidthLength.computeI(Math.min(input.width, input.height));
        if (input.width < regionWidth || input.height < regionWidth) {
            throw new IllegalArgumentException("Image is smaller than region size");
        }
        this.numPixels = regionWidth * regionWidth;
        int y0 = regionWidth / 2;
        int y1 = input.height - (regionWidth - y0);
        int x0 = regionWidth / 2;
        int x1 = input.width - (regionWidth - x0);
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            this.computeHistogram(0, y - y0, input);
            output.data[indexOutput++] = this.otsu.down == (double)(input.data[indexInput++] & 0xFF) <= this.otsu.threshold ? (byte)1 : 0;
            for (int x = x0 + 1; x < x1; ++x) {
                this.updateHistogramX(x - x0, y - y0, input);
                output.data[indexOutput++] = this.otsu.down == (double)(input.data[indexInput++] & 0xFF) <= this.otsu.threshold ? (byte)1 : 0;
            }
        }
        this.applyToBorder(input, output, y0, y1, x0, x1);
    }

    private void applyToBorder(GrayU8 input, GrayU8 output, int y0, int y1, int x0, int x1) {
        int y;
        int x;
        this.computeHistogram(0, 0, input);
        this.applyToBlock(0, 0, x0 + 1, y0 + 1, input, output);
        for (x = x0 + 1; x < x1; ++x) {
            this.updateHistogramX(x - x0, 0, input);
            this.applyToBlock(x, 0, x + 1, y0, input, output);
        }
        this.updateHistogramX(x1 - x0, 0, input);
        this.applyToBlock(x1, 0, input.width, y0 + 1, input, output);
        for (y = y0 + 1; y < y1; ++y) {
            this.updateHistogramY(x1 - x0, y - y0, input);
            this.applyToBlock(x1, y, input.width, y + 1, input, output);
        }
        this.updateHistogramY(x1 - x0, y1 - y0, input);
        this.applyToBlock(x1, y1, input.width, input.height, input, output);
        this.computeHistogram(0, 0, input);
        for (y = y0 + 1; y < y1; ++y) {
            this.updateHistogramY(0, y - y0, input);
            this.applyToBlock(0, y, x0, y + 1, input, output);
        }
        this.updateHistogramY(0, y1 - y0, input);
        this.applyToBlock(0, y1, x0 + 1, input.height, input, output);
        for (x = x0 + 1; x < x1; ++x) {
            this.updateHistogramX(x - x0, y1 - y0, input);
            this.applyToBlock(x, y1, x + 1, input.height, input, output);
        }
    }

    @Override
    public ImageType<GrayU8> getInputType() {
        return null;
    }

    private void applyToBlock(int x0, int y0, int x1, int y1, GrayU8 input, GrayU8 output) {
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int end = indexOutput + (x1 - x0);
            while (indexOutput < end) {
                output.data[indexOutput++] = this.otsu.down == (double)(input.data[indexInput++] & 0xFF) <= this.otsu.threshold ? (byte)1 : 0;
            }
        }
    }

    protected void computeHistogram(int x0, int y0, GrayU8 input) {
        Arrays.fill(this.histogram, 0);
        for (int y = 0; y < this.regionWidth; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < this.regionWidth; ++x) {
                int n = input.data[indexInput++] & 0xFF;
                this.histogram[n] = this.histogram[n] + 1;
            }
        }
        this.otsu.compute(this.histogram, this.histogram.length, this.numPixels);
    }

    protected void updateHistogramX(int x0, int y0, GrayU8 input) {
        for (int y = 0; y < this.regionWidth; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0 - 1;
            int n = input.data[indexInput] & 0xFF;
            this.histogram[n] = this.histogram[n] - 1;
            int n2 = input.data[indexInput + this.regionWidth] & 0xFF;
            this.histogram[n2] = this.histogram[n2] + 1;
        }
        this.otsu.compute(this.histogram, this.histogram.length, this.numPixels);
    }

    protected void updateHistogramY(int x0, int y0, GrayU8 input) {
        int offset = this.regionWidth * input.stride;
        for (int x = 0; x < this.regionWidth; ++x) {
            int indexInput = input.startIndex + (y0 - 1) * input.stride + x0 + x;
            int n = input.data[indexInput] & 0xFF;
            this.histogram[n] = this.histogram[n] - 1;
            int n2 = input.data[indexInput + offset] & 0xFF;
            this.histogram[n2] = this.histogram[n2] + 1;
        }
        this.otsu.compute(this.histogram, this.histogram.length, this.numPixels);
    }

    public ImageType<GrayU8> getImageType() {
        return this.imageType;
    }

    public ComputeOtsu getOtsu() {
        return this.otsu;
    }
}

