/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdBlockMinMax;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;

public class ThresholdBlockMinMax_F32
extends ThresholdBlockMinMax<GrayF32, InterleavedF32> {
    float scale;
    boolean down;

    public ThresholdBlockMinMax_F32(float minimumSpread, ConfigLength requestedBlockWidth, float scale, boolean down, boolean thresholdFromLocalBlocks) {
        super(minimumSpread, requestedBlockWidth, thresholdFromLocalBlocks, GrayF32.class);
        this.stats = new InterleavedF32(1, 1, 2);
        this.scale = scale;
        this.down = down;
    }

    @Override
    protected void thresholdBlock(int blockX0, int blockY0, GrayF32 input, GrayU8 output) {
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == ((InterleavedF32)this.stats).width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == ((InterleavedF32)this.stats).height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(((InterleavedF32)this.stats).width - 1, blockX0 + 1);
            blockY1 = Math.min(((InterleavedF32)this.stats).height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                float localMin = ((InterleavedF32)this.stats).getBand(x, y, 0);
                float localMax = ((InterleavedF32)this.stats).getBand(x, y, 1);
                if (localMin < min) {
                    min = localMin;
                }
                if (!(localMax > max)) continue;
                max = localMax;
            }
        }
        float textureThreshold = (float)this.minimumSpread;
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int x = x0;
            while (x < x1) {
                float average;
                output.data[indexOutput] = max - min <= textureThreshold ? (byte)1 : (this.down == input.data[indexInput] <= (average = this.scale * (max + min) / 2.0f) ? (byte)1 : 0);
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    protected void computeBlockStatistics(int x0, int y0, int width, int height, int indexMinMax, GrayF32 input) {
        float max;
        float min = max = input.unsafe_get(x0, y0);
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                int n = indexInput++;
                float value = input.data[n];
                if (value < min) {
                    min = value;
                    continue;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        ((InterleavedF32)this.stats).data[indexMinMax] = min;
        ((InterleavedF32)this.stats).data[indexMinMax + 1] = max;
    }
}

