/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalizedNaive_IL;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalizedNaive_SB;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalized_JustBorder_IL;
import boofcv.alg.filter.convolve.normalized.ConvolveNormalized_JustBorder_SB;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedU8;

public class ConvolveNormalized {
    public static void horizontal(Kernel1D_F32 kernel, GrayF32 src, GrayF32 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_SB.horizontal(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0f) > 1.0E-4f) {
                Kernel1D_F32 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.horizontal(kernel, src, dst);
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_F32 kernel, GrayF32 src, GrayF32 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.vertical(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0f) > 1.0E-4f) {
                Kernel1D_F32 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.vertical(kernel, src, dst);
            ConvolveNormalized_JustBorder_SB.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_F32 kernel, GrayF32 src, GrayF32 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.convolve(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0f) > 1.0E-4f) {
                Kernel2D_F32 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.convolve(kernel, src, dst);
            ConvolveNormalized_JustBorder_SB.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_F32 kernel, InterleavedF32 src, InterleavedF32 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_IL.horizontal(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0f) > 1.0E-4f) {
                Kernel1D_F32 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.horizontal(kernel, src, dst);
            ConvolveNormalized_JustBorder_IL.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_F32 kernel, InterleavedF32 src, InterleavedF32 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.vertical(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0f) > 1.0E-4f) {
                Kernel1D_F32 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.vertical(kernel, src, dst);
            ConvolveNormalized_JustBorder_IL.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_F32 kernel, InterleavedF32 src, InterleavedF32 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.convolve(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0f) > 1.0E-4f) {
                Kernel2D_F32 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.convolve(kernel, src, dst);
            ConvolveNormalized_JustBorder_IL.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_F64 kernel, GrayF64 src, GrayF64 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_SB.horizontal(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0) > (double)1.0E-4f) {
                Kernel1D_F64 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.horizontal(kernel, src, dst);
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_F64 kernel, GrayF64 src, GrayF64 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.vertical(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0) > (double)1.0E-4f) {
                Kernel1D_F64 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.vertical(kernel, src, dst);
            ConvolveNormalized_JustBorder_SB.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_F64 kernel, GrayF64 src, GrayF64 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.convolve(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0) > (double)1.0E-4f) {
                Kernel2D_F64 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.convolve(kernel, src, dst);
            ConvolveNormalized_JustBorder_SB.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_F64 kernel, InterleavedF64 src, InterleavedF64 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_IL.horizontal(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0) > (double)1.0E-4f) {
                Kernel1D_F64 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.horizontal(kernel, src, dst);
            ConvolveNormalized_JustBorder_IL.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_F64 kernel, InterleavedF64 src, InterleavedF64 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.vertical(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0) > (double)1.0E-4f) {
                Kernel1D_F64 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.vertical(kernel, src, dst);
            ConvolveNormalized_JustBorder_IL.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_F64 kernel, InterleavedF64 src, InterleavedF64 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.convolve(kernel, src, dst);
        } else {
            if (Math.abs(kernel.computeSum() - 1.0) > (double)1.0E-4f) {
                Kernel2D_F64 k = kernel.copy();
                KernelMath.normalizeSumToOne(k);
                kernel = k;
            }
            ConvolveImageNoBorder.convolve(kernel, src, dst);
            ConvolveNormalized_JustBorder_IL.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 src, GrayI8 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_SB.horizontal(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.horizontal(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 src, GrayI8 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.vertical(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.vertical(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 src, GrayI8 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.convolve(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.convolve(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedU8 src, InterleavedI8 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_IL.horizontal(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.horizontal(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedU8 src, InterleavedI8 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.vertical(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.vertical(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedU8 src, InterleavedI8 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.convolve(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.convolve(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS16 src, GrayI16 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_SB.horizontal(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.horizontal(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS16 src, GrayI16 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.vertical(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.vertical(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS16 src, GrayI16 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.convolve(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.convolve(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedS16 src, InterleavedI16 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_IL.horizontal(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.horizontal(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedS16 src, InterleavedI16 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.vertical(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.vertical(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedS16 src, InterleavedI16 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.convolve(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.convolve(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS32 src, GrayS32 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_SB.horizontal(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.horizontal(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS32 src, GrayS32 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.vertical(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.vertical(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS32 src, GrayS32 dst) {
        InputSanityCheck.checkSameShape(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_SB.convolve(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.convolve(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_SB.convolve(kernel, src, dst);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, InterleavedS32 src, InterleavedS32 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width) {
            ConvolveNormalizedNaive_IL.horizontal(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.horizontal(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.horizontal(kernel, src, dst);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, InterleavedS32 src, InterleavedS32 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.vertical(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.vertical(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.vertical(kernel, src, dst);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, InterleavedS32 src, InterleavedS32 dst) {
        InputSanityCheck.checkSameShapeB(src, dst);
        if (kernel.width >= src.width || kernel.width >= src.height) {
            ConvolveNormalizedNaive_IL.convolve(kernel, src, dst);
        } else {
            ConvolveImageNoBorder.convolve(kernel, src, dst, kernel.computeSum());
            ConvolveNormalized_JustBorder_IL.convolve(kernel, src, dst);
        }
    }
}

