/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate;

import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;

public abstract class BilinearPixelMB<T extends ImageInterleaved<T>>
implements InterpolatePixelMB<T> {
    protected ImageBorder<T> border;
    protected T orig;
    protected int stride;
    protected int width;
    protected int height;

    @Override
    public void setBorder(ImageBorder<T> border) {
        this.border = border;
    }

    @Override
    public void setImage(T image) {
        if (this.border != null) {
            this.border.setImage(image);
        }
        this.orig = image;
        this.stride = ((ImageBase)this.orig).getStride();
        this.width = ((ImageBase)this.orig).getWidth();
        this.height = ((ImageBase)this.orig).getHeight();
    }

    @Override
    public T getImage() {
        return this.orig;
    }

    @Override
    public boolean isInFastBounds(float x, float y) {
        return !(x < 0.0f || y < 0.0f || x > (float)(this.width - 2) || y > (float)(this.height - 2));
    }

    @Override
    public int getFastBorderX() {
        return 1;
    }

    @Override
    public int getFastBorderY() {
        return 1;
    }

    @Override
    public ImageBorder<T> getBorder() {
        return this.border;
    }
}

