/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.alg.InputSanityCheck;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayF;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import boofcv.testing.BoofTesting;

public class GeneralizedImageOps {
    public static <T extends ImageGray<T>> T convert(ImageGray<?> src, T dst, Class<T> typeDst) {
        if (dst == null) {
            dst = GeneralizedImageOps.createSingleBand(typeDst, src.width, src.height);
        } else {
            InputSanityCheck.checkSameShape(src, dst);
        }
        GConvertImage.convert(src, dst);
        return dst;
    }

    public static boolean isFloatingPoint(Class<?> imgType) {
        return GrayF.class.isAssignableFrom(imgType);
    }

    public static double get(ImageGray img, int x, int y) {
        if (img instanceof GrayI8) {
            return ((GrayI8)img).get(x, y);
        }
        if (img instanceof GrayI16) {
            return ((GrayI16)img).get(x, y);
        }
        if (img instanceof GrayS32) {
            return ((GrayS32)img).get(x, y);
        }
        if (img instanceof GrayF32) {
            return ((GrayF32)img).get(x, y);
        }
        if (img instanceof GrayF64) {
            return ((GrayF64)img).get(x, y);
        }
        if (img instanceof GrayS64) {
            return ((GrayS64)img).get(x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageBase img, int x, int y, int band) {
        if (img instanceof ImageGray) {
            return GeneralizedImageOps.get((ImageGray)img, x, y);
        }
        if (img instanceof ImageInterleaved) {
            return GeneralizedImageOps.get((ImageInterleaved)img, x, y, band);
        }
        if (img instanceof Planar) {
            return GeneralizedImageOps.get(((Planar)img).getBand(band), x, y);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static double get(ImageInterleaved img, int x, int y, int band) {
        if (img instanceof InterleavedU8) {
            return ((InterleavedU8)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS8) {
            return ((InterleavedS8)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS16) {
            return ((InterleavedS16)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedU16) {
            return ((InterleavedU16)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS32) {
            return ((InterleavedS32)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedS64) {
            return ((InterleavedS64)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedF32) {
            return ((InterleavedF32)img).getBand(x, y, band);
        }
        if (img instanceof InterleavedF64) {
            return ((InterleavedF64)img).getBand(x, y, band);
        }
        throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
    }

    public static <T extends ImageGray> T createSingleBand(ImageDataType type, int width, int height) {
        Class typeClass = ImageType.getImageClass(ImageType.Family.GRAY, type);
        return GeneralizedImageOps.createSingleBand(typeClass, width, height);
    }

    public static <T extends ImageBase> T createImage(Class<T> type, int width, int height, int numBands) {
        if (type == Planar.class) {
            throw new IllegalArgumentException("Can't use this function with planar because the data type needs to be specified too");
        }
        if (ImageGray.class.isAssignableFrom(type)) {
            return GeneralizedImageOps.createSingleBand(type, width, height);
        }
        if (ImageInterleaved.class.isAssignableFrom(type)) {
            return GeneralizedImageOps.createInterleaved(type, width, height, numBands);
        }
        throw new RuntimeException("Unknown");
    }

    public static <T extends ImageGray<T>> T createSingleBand(Class<T> type, int width, int height) {
        if ((type = (Class)BoofTesting.convertGenericToSpecificType(type)) == GrayU8.class) {
            return (T)new GrayU8(width, height);
        }
        if (type == GrayS8.class) {
            return (T)new GrayS8(width, height);
        }
        if (type == GrayS16.class) {
            return (T)new GrayS16(width, height);
        }
        if (type == GrayU16.class) {
            return (T)new GrayU16(width, height);
        }
        if (type == GrayS32.class) {
            return (T)new GrayS32(width, height);
        }
        if (type == GrayS64.class) {
            return (T)new GrayS64(width, height);
        }
        if (type == GrayF32.class) {
            return (T)new GrayF32(width, height);
        }
        if (type == GrayF64.class) {
            return (T)new GrayF64(width, height);
        }
        if (type == GrayI.class) {
            return (T)new GrayS32(width, height);
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }

    public static <T extends ImageInterleaved> T createInterleaved(ImageDataType type, int width, int height, int numBands) {
        Class typeClass = ImageType.getImageClass(ImageType.Family.INTERLEAVED, type);
        return GeneralizedImageOps.createInterleaved(typeClass, width, height, numBands);
    }

    public static <T extends ImageInterleaved<T>> T createInterleaved(Class<T> type, int width, int height, int numBands) {
        if ((type = (Class)BoofTesting.convertGenericToSpecificType(type)) == InterleavedU8.class) {
            return (T)new InterleavedU8(width, height, numBands);
        }
        if (type == InterleavedS8.class) {
            return (T)new InterleavedS8(width, height, numBands);
        }
        if (type == InterleavedU16.class) {
            return (T)new InterleavedU16(width, height, numBands);
        }
        if (type == InterleavedS16.class) {
            return (T)new InterleavedS16(width, height, numBands);
        }
        if (type == InterleavedS32.class) {
            return (T)new InterleavedS32(width, height, numBands);
        }
        if (type == InterleavedS64.class) {
            return (T)new InterleavedS64(width, height, numBands);
        }
        if (type == InterleavedF32.class) {
            return (T)new InterleavedF32(width, height, numBands);
        }
        if (type == InterleavedF64.class) {
            return (T)new InterleavedF64(width, height, numBands);
        }
        if (type == ImageInterleaved.class) {
            return (T)new InterleavedS32(width, height, numBands);
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }

    public static void set(ImageGray img, int x, int y, double value) {
        if (GrayI.class.isAssignableFrom(img.getClass())) {
            ((GrayI)img).set(x, y, (int)value);
        } else if (img instanceof GrayF32) {
            ((GrayF32)img).set(x, y, (float)value);
        } else if (img instanceof GrayF64) {
            ((GrayF64)img).set(x, y, value);
        } else if (img instanceof GrayS64) {
            ((GrayS64)img).set(x, y, (long)value);
        } else {
            throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
        }
    }

    public static void setM(ImageBase img, int x, int y, double ... value) {
        if (img instanceof Planar) {
            Planar ms = (Planar)img;
            for (int i = 0; i < value.length; ++i) {
                GeneralizedImageOps.set(ms.getBand(i), x, y, value[i]);
            }
        } else if (img instanceof ImageInterleaved) {
            for (int band = 0; band < value.length; ++band) {
                if (img instanceof InterleavedU8) {
                    ((InterleavedU8)img).setBand(x, y, band, (byte)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS8) {
                    ((InterleavedS8)img).setBand(x, y, band, (byte)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS16) {
                    ((InterleavedS16)img).setBand(x, y, band, (short)value[band]);
                    continue;
                }
                if (img instanceof InterleavedU16) {
                    ((InterleavedU16)img).setBand(x, y, band, (short)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS32) {
                    ((InterleavedS32)img).setBand(x, y, band, (int)value[band]);
                    continue;
                }
                if (img instanceof InterleavedS64) {
                    ((InterleavedS64)img).setBand(x, y, band, (long)value[band]);
                    continue;
                }
                if (img instanceof InterleavedF32) {
                    ((InterleavedF32)img).setBand(x, y, band, (float)value[band]);
                    continue;
                }
                if (img instanceof InterleavedF64) {
                    ((InterleavedF64)img).setBand(x, y, band, value[band]);
                    continue;
                }
                throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
            }
        } else if (img instanceof ImageGray) {
            if (value.length != 1) {
                throw new IllegalArgumentException("For a single band image the input pixel must have 1 band");
            }
            GeneralizedImageOps.set((ImageGray)img, x, y, value[0]);
        } else {
            throw new IllegalArgumentException("Add support for this image type!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setB(ImageBase img, int x, int y, int band, double value) {
        if (img instanceof Planar) {
            Planar ms = (Planar)img;
            GeneralizedImageOps.set(ms.getBand(band), x, y, value);
            return;
        } else if (img instanceof ImageInterleaved) {
            if (img instanceof InterleavedU8) {
                ((InterleavedU8)img).setBand(x, y, band, (byte)value);
                return;
            } else if (img instanceof InterleavedS8) {
                ((InterleavedS8)img).setBand(x, y, band, (byte)value);
                return;
            } else if (img instanceof InterleavedS16) {
                ((InterleavedS16)img).setBand(x, y, band, (short)value);
                return;
            } else if (img instanceof InterleavedU16) {
                ((InterleavedU16)img).setBand(x, y, band, (short)value);
                return;
            } else if (img instanceof InterleavedS32) {
                ((InterleavedS32)img).setBand(x, y, band, (int)value);
                return;
            } else if (img instanceof InterleavedS64) {
                ((InterleavedS64)img).setBand(x, y, band, (long)value);
                return;
            } else if (img instanceof InterleavedF32) {
                ((InterleavedF32)img).setBand(x, y, band, (float)value);
                return;
            } else {
                if (!(img instanceof InterleavedF64)) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ((InterleavedF64)img).setBand(x, y, band, value);
            }
            return;
        } else {
            if (!(img instanceof ImageGray)) throw new IllegalArgumentException("Add support for this image type!");
            if (band != 0) {
                throw new IllegalArgumentException("For a single band image the input pixel must have 1 band");
            }
            GeneralizedImageOps.set((ImageGray)img, x, y, value);
        }
    }

    public static <T extends ImageGray<T>> int getNumBits(Class<T> type) {
        if (type == GrayU8.class) {
            return 8;
        }
        if (type == GrayS8.class) {
            return 8;
        }
        if (type == GrayS16.class) {
            return 16;
        }
        if (type == GrayU16.class) {
            return 16;
        }
        if (type == GrayS32.class) {
            return 32;
        }
        if (type == GrayS64.class) {
            return 64;
        }
        if (type == GrayF32.class) {
            return 32;
        }
        if (type == GrayF64.class) {
            return 64;
        }
        throw new RuntimeException("Unknown type: " + type.getSimpleName());
    }
}

