/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.abst.filter.binary.GlobalEntropyBinaryFilter;
import boofcv.abst.filter.binary.GlobalFixedBinaryFilter;
import boofcv.abst.filter.binary.GlobalOtsuBinaryFilter;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.filter.binary.InputToBinarySwitchF32;
import boofcv.abst.filter.binary.InputToBinarySwitchU8;
import boofcv.abst.filter.binary.LocalGaussianBinaryFilter;
import boofcv.abst.filter.binary.LocalMeanBinaryFilter;
import boofcv.alg.filter.binary.ThresholdBlockOtsu;
import boofcv.alg.filter.binary.ThresholdLocalOtsu;
import boofcv.alg.filter.binary.impl.ThresholdBlockMean_F32;
import boofcv.alg.filter.binary.impl.ThresholdBlockMean_U8;
import boofcv.alg.filter.binary.impl.ThresholdBlockMinMax_F32;
import boofcv.alg.filter.binary.impl.ThresholdBlockMinMax_U8;
import boofcv.alg.filter.binary.impl.ThresholdSauvola;
import boofcv.factory.filter.binary.BOverrideFactoryThresholdBinary;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class FactoryThresholdBinary {
    public static <T extends ImageGray<T>> InputToBinary<T> localGaussian(ConfigLength regionWidth, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localGaussian != null) {
            return BOverrideFactoryThresholdBinary.localGaussian.handle(regionWidth, scale, down, inputType);
        }
        return new LocalGaussianBinaryFilter<T>(regionWidth, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localSauvola(ConfigLength width, float k, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localSauvola != null) {
            return BOverrideFactoryThresholdBinary.localSauvola.handle(width, k, down, inputType);
        }
        return new InputToBinarySwitchF32<T>(new ThresholdSauvola(width, k, down), inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localMean(ConfigLength width, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localMean != null) {
            return BOverrideFactoryThresholdBinary.localMean.handle(width, scale, down, inputType);
        }
        return new LocalMeanBinaryFilter<T>(width, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> localOtsu(boolean otsu2, ConfigLength regionWidth, double tuning, double scale, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.localOtsu != null) {
            return BOverrideFactoryThresholdBinary.localOtsu.handle(otsu2, regionWidth, tuning, scale, down, inputType);
        }
        return new InputToBinarySwitchU8<T>(new ThresholdLocalOtsu(otsu2, regionWidth, tuning, scale, down), inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockMinMax(ConfigLength regionWidth, double scale, boolean down, double minimumSpread, boolean thresholdFromLocalBlocks, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockMinMax != null) {
            return BOverrideFactoryThresholdBinary.blockMinMax.handle(regionWidth, scale, down, minimumSpread, thresholdFromLocalBlocks, inputType);
        }
        if (inputType == GrayU8.class) {
            return new ThresholdBlockMinMax_U8(minimumSpread, regionWidth, scale, down, thresholdFromLocalBlocks);
        }
        return new ThresholdBlockMinMax_F32((float)minimumSpread, regionWidth, (float)scale, down, thresholdFromLocalBlocks);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockMean(ConfigLength regionWidth, double scale, boolean down, boolean thresholdFromLocalBlocks, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockMean != null) {
            return BOverrideFactoryThresholdBinary.blockMean.handle(regionWidth, scale, down, thresholdFromLocalBlocks, inputType);
        }
        if (inputType == GrayU8.class) {
            return new ThresholdBlockMean_U8(regionWidth, scale, down, thresholdFromLocalBlocks);
        }
        return new ThresholdBlockMean_F32(regionWidth, scale, down, thresholdFromLocalBlocks);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> blockOtsu(boolean otsu2, ConfigLength regionWidth, double tuning, double scale, boolean down, boolean thresholdFromLocalBlocks, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.blockOtsu != null) {
            return BOverrideFactoryThresholdBinary.blockOtsu.handle(otsu2, regionWidth, tuning, scale, down, thresholdFromLocalBlocks, inputType);
        }
        return new InputToBinarySwitchU8<T>(new ThresholdBlockOtsu(otsu2, regionWidth, tuning, scale, down, thresholdFromLocalBlocks), inputType);
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalEntropy(int minValue, int maxValue, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalEntropy != null) {
            return BOverrideFactoryThresholdBinary.globalEntropy.handle(minValue, maxValue, down, inputType);
        }
        return new GlobalEntropyBinaryFilter<T>(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalFixed(double threshold, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalFixed != null) {
            return BOverrideFactoryThresholdBinary.globalFixed.handle(threshold, down, inputType);
        }
        return new GlobalFixedBinaryFilter<T>(threshold, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> globalOtsu(int minValue, int maxValue, boolean down, Class<T> inputType) {
        if (BOverrideFactoryThresholdBinary.globalOtsu != null) {
            return BOverrideFactoryThresholdBinary.globalOtsu.handle(minValue, maxValue, down, inputType);
        }
        return new GlobalOtsuBinaryFilter<T>(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray<T>> InputToBinary<T> threshold(ConfigThreshold config, Class<T> inputType) {
        switch (config.type) {
            case FIXED: {
                return FactoryThresholdBinary.globalFixed(config.fixedThreshold, config.down, inputType);
            }
            case GLOBAL_OTSU: {
                return FactoryThresholdBinary.globalOtsu(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case GLOBAL_ENTROPY: {
                return FactoryThresholdBinary.globalEntropy(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case LOCAL_GAUSSIAN: {
                return FactoryThresholdBinary.localGaussian(config.width, config.scale, config.down, inputType);
            }
            case LOCAL_SAVOLA: {
                return FactoryThresholdBinary.localSauvola(config.width, config.savolaK, config.down, inputType);
            }
            case LOCAL_MEAN: {
                return FactoryThresholdBinary.localMean(config.width, config.scale, config.down, inputType);
            }
            case LOCAL_OTSU: {
                ConfigThresholdLocalOtsu c = (ConfigThresholdLocalOtsu)config;
                return FactoryThresholdBinary.localOtsu(c.useOtsu2, config.width, c.tuning, config.scale, config.down, inputType);
            }
            case BLOCK_MIN_MAX: {
                ConfigThresholdBlockMinMax c = (ConfigThresholdBlockMinMax)config;
                return FactoryThresholdBinary.blockMinMax(c.width, c.scale, c.down, c.minimumSpread, c.thresholdFromLocalBlocks, inputType);
            }
            case BLOCK_MEAN: {
                return FactoryThresholdBinary.blockMean(config.width, config.scale, config.down, config.thresholdFromLocalBlocks, inputType);
            }
            case BLOCK_OTSU: {
                ConfigThresholdLocalOtsu c = (ConfigThresholdLocalOtsu)config;
                return FactoryThresholdBinary.blockOtsu(c.useOtsu2, c.width, c.tuning, c.scale, c.down, c.thresholdFromLocalBlocks, inputType);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)config.type));
    }
}

