/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.io.Serializable;
import java.lang.reflect.Array;

public class ImageType<T extends ImageBase>
implements Serializable {
    Family family;
    ImageDataType dataType;
    public int numBands;

    public ImageType(Family family, ImageDataType dataType, int numBands) {
        this.family = family;
        this.dataType = dataType;
        this.numBands = numBands;
    }

    public static <I extends ImageGray<I>> ImageType<I> single(Class<I> imageType) {
        return new ImageType(Family.GRAY, ImageDataType.classToType(imageType), 1);
    }

    public static <I extends ImageGray<I>> ImageType<I> single(ImageDataType type) {
        return new ImageType(Family.GRAY, type, 1);
    }

    public static <I extends ImageGray<I>> ImageType<Planar<I>> pl(int numBands, Class<I> imageType) {
        return new ImageType<Planar<I>>(Family.PLANAR, ImageDataType.classToType(imageType), numBands);
    }

    public static <I extends ImageGray<I>> ImageType<Planar<I>> pl(int numBands, ImageDataType type) {
        return new ImageType<Planar<I>>(Family.PLANAR, type, numBands);
    }

    public static <I extends ImageInterleaved<I>> ImageType<I> il(int numBands, Class<I> imageType) {
        return new ImageType(Family.INTERLEAVED, ImageDataType.classToType(imageType), numBands);
    }

    public static <I extends ImageInterleaved<I>> ImageType<I> il(int numBands, ImageDataType type) {
        return new ImageType(Family.INTERLEAVED, type, numBands);
    }

    public ImageDataType getDataType() {
        return this.dataType;
    }

    public T createImage(int width, int height) {
        switch (this.family) {
            case GRAY: {
                return GeneralizedImageOps.createSingleBand(this.getImageClass(), width, height);
            }
            case INTERLEAVED: {
                return GeneralizedImageOps.createInterleaved(this.getImageClass(), width, height, this.numBands);
            }
            case PLANAR: {
                return (T)new Planar(this.getImageClass(), width, height, this.numBands);
            }
        }
        throw new IllegalArgumentException("Type not yet supported");
    }

    public T[] createArray(int length) {
        switch (this.family) {
            case GRAY: 
            case INTERLEAVED: {
                return (ImageBase[])Array.newInstance(this.getImageClass(), length);
            }
            case PLANAR: {
                return new Planar[length];
            }
        }
        throw new IllegalArgumentException("Type not yet supported");
    }

    public int getNumBands() {
        return this.numBands;
    }

    public Family getFamily() {
        return this.family;
    }

    public Class getImageClass() {
        return ImageType.getImageClass(this.family, this.dataType);
    }

    public static Class getImageClass(Family family, ImageDataType dataType) {
        switch (family) {
            case GRAY: 
            case PLANAR: {
                switch (dataType) {
                    case F32: {
                        return GrayF32.class;
                    }
                    case F64: {
                        return GrayF64.class;
                    }
                    case U8: {
                        return GrayU8.class;
                    }
                    case S8: {
                        return GrayS8.class;
                    }
                    case U16: {
                        return GrayU16.class;
                    }
                    case S16: {
                        return GrayS16.class;
                    }
                    case S32: {
                        return GrayS32.class;
                    }
                    case S64: {
                        return GrayS64.class;
                    }
                    case I8: {
                        return GrayI8.class;
                    }
                    case I16: {
                        return GrayI16.class;
                    }
                }
                break;
            }
            case INTERLEAVED: {
                switch (dataType) {
                    case F32: {
                        return InterleavedF32.class;
                    }
                    case F64: {
                        return InterleavedF64.class;
                    }
                    case U8: {
                        return InterleavedU8.class;
                    }
                    case S8: {
                        return InterleavedS8.class;
                    }
                    case U16: {
                        return InterleavedU16.class;
                    }
                    case S16: {
                        return InterleavedS16.class;
                    }
                    case S32: {
                        return InterleavedS32.class;
                    }
                    case S64: {
                        return InterleavedS64.class;
                    }
                    case I8: {
                        return InterleavedI8.class;
                    }
                    case I16: {
                        return InterleavedI16.class;
                    }
                }
            }
        }
        throw new RuntimeException("Support this image type thing");
    }

    public String toString() {
        return "ImageType( " + (Object)((Object)this.family) + " " + (Object)((Object)this.dataType) + " " + this.numBands + " )";
    }

    public static enum Family {
        GRAY,
        PLANAR,
        INTERLEAVED;

    }
}

