/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.alg.filter.binary.ContourPacked;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public interface BinaryContourFinder {
    public void process(GrayU8 var1, GrayS32 var2);

    public List<ContourPacked> getContours();

    public void loadContour(int var1, FastQueue<Point2D_I32> var2);

    public void writeContour(int var1, List<Point2D_I32> var2);

    public static List<Point2D_I32> copyContour(BinaryContourFinder finder, int contourID) {
        FastQueue storage = new FastQueue(Point2D_I32.class, true);
        finder.loadContour(contourID, (FastQueue<Point2D_I32>)storage);
        ArrayList<Point2D_I32> list = new ArrayList<Point2D_I32>(storage.size);
        for (int i = 0; i < storage.size; ++i) {
            list.add((Point2D_I32)storage.get(i));
        }
        return list;
    }

    public void setSaveInnerContour(boolean var1);

    public boolean isSaveInternalContours();

    public void setMinContour(int var1);

    public int getMinContour();

    public void setMaxContour(int var1);

    public int getMaxContour();

    public void setConnectRule(ConnectRule var1);

    public ConnectRule getConnectRule();
}

