/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class InputToBinarySwitchF32<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    InputToBinary<GrayF32> alg;
    GrayF32 input;

    public InputToBinarySwitchF32(InputToBinary<GrayF32> alg, Class<T> inputType) {
        this.alg = alg;
        this.inputType = ImageType.single(inputType);
        if (this.inputType.getDataType() != ImageDataType.F32) {
            this.input = new GrayF32(1, 1);
        }
    }

    @Override
    public void process(T input, GrayU8 output) {
        if (this.input == null) {
            this.alg.process((GrayF32)input, output);
        } else {
            this.input.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, this.input);
            this.alg.process(this.input, output);
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }
}

