/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.ImageHessianDirect;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.BoofDefaults;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ImageHessianDirect_Reflection<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageHessianDirect<Input, Output> {
    BorderType borderType = BoofDefaults.DERIV_BORDER_TYPE;
    ImageBorder<Output> border;
    private Method m;

    public ImageHessianDirect_Reflection(Method m) {
        this.m = m;
        this.setBorderType(this.borderType);
    }

    @Override
    public void process(Input inputImage, Output derivXX, Output derivYY, Output derivXY) {
        try {
            this.m.invoke(null, inputImage, derivXX, derivYY, derivXY, this.border);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        Class<?> imageType = this.m.getParameterTypes()[0];
        this.border = FactoryImageBorder.single(imageType, this.borderType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        if (this.borderType != BorderType.SKIP) {
            return 0;
        }
        return 1;
    }

    @Override
    public ImageType<Output> getDerivativeType() {
        return ImageType.single(this.m.getParameterTypes()[1]);
    }
}

