/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdBlockMean;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;

public class ThresholdBlockMean_U8
extends ThresholdBlockMean<GrayU8> {
    double scale;
    boolean down;

    public ThresholdBlockMean_U8(ConfigLength requestedBlockWidth, double scale, boolean down, boolean thresholdFromLocalBlocks) {
        super(requestedBlockWidth, thresholdFromLocalBlocks, GrayU8.class);
        this.stats = new GrayU8(1, 1);
        this.scale = scale;
        this.down = down;
    }

    @Override
    protected void thresholdBlock(int blockX0, int blockY0, GrayU8 input, GrayU8 output) {
        byte b;
        byte a;
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == ((GrayU8)this.stats).width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == ((GrayU8)this.stats).height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(((GrayU8)this.stats).width - 1, blockX0 + 1);
            blockY1 = Math.min(((GrayU8)this.stats).height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        int mean = 0;
        for (int y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                mean += ((GrayU8)this.stats).unsafe_get(x, y);
            }
        }
        mean /= (blockY1 - blockY0 + 1) * (blockX1 - blockX0 + 1);
        if (this.down) {
            a = 1;
            b = 0;
        } else {
            a = 0;
            b = 1;
        }
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int end = indexOutput + (x1 - x0);
            while (indexOutput < end) {
                output.data[indexOutput] = (input.data[indexInput] & 0xFF) <= mean ? a : b;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    protected void computeBlockStatistics(int x0, int y0, int width, int height, int indexStats, GrayU8 input) {
        int sum = 0;
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                sum += input.data[indexInput++] & 0xFF;
            }
        }
        sum = (int)(this.scale * (double)sum / (double)(width * height) + 0.5);
        ((GrayU8)this.stats).data[indexStats] = (byte)sum;
    }
}

