/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.blur.BOverrideBlurImageOps;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.filter.blur.impl.ImplMedianHistogramInner;
import boofcv.alg.filter.blur.impl.ImplMedianSortEdgeNaive;
import boofcv.alg.filter.blur.impl.ImplMedianSortNaive;
import boofcv.alg.filter.convolve.ConvolveImageMean;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import javax.annotation.Nullable;

public class BlurImageOps {
    public static GrayU8 mean(GrayU8 input, @Nullable GrayU8 output, int radius, @Nullable GrayU8 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = InputSanityCheck.checkDeclare(input, output), radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, storage, radius);
            ConvolveImageMean.vertical(storage, output, radius);
        }
        return output;
    }

    public static GrayF32 mean(GrayF32 input, @Nullable GrayF32 output, int radius, @Nullable GrayF32 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = InputSanityCheck.checkDeclare(input, output), radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, storage, radius);
            ConvolveImageMean.vertical(storage, output, radius);
        }
        return output;
    }

    public static GrayF64 mean(GrayF64 input, @Nullable GrayF64 output, int radius, @Nullable GrayF64 storage) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMean(input, output = InputSanityCheck.checkDeclare(input, output), radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            ConvolveImageMean.horizontal(input, storage, radius);
            ConvolveImageMean.vertical(storage, output, radius);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> mean(Planar<T> input, @Nullable Planar<T> output, int radius, @Nullable T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.mean(input.getBand(band), ((Planar)output).getBand(band), radius, storage);
        }
        return output;
    }

    public static GrayU8 median(GrayU8 input, @Nullable GrayU8 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMedian(input, output = InputSanityCheck.checkDeclare(input, output), radius);
        if (!processed) {
            int w = radius * 2 + 1;
            int[] offset = new int[w * w];
            int[] histogram = new int[256];
            ImplMedianHistogramInner.process(input, output, radius, offset, histogram);
            ImplMedianSortEdgeNaive.process(input, output, radius, offset);
        }
        return output;
    }

    public static GrayF32 median(GrayF32 input, @Nullable GrayF32 output, int radius) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        boolean processed = BOverrideBlurImageOps.invokeNativeMedian(input, output = InputSanityCheck.checkDeclare(input, output), radius);
        if (!processed) {
            ImplMedianSortNaive.process(input, output, radius, null);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> median(Planar<T> input, @Nullable Planar<T> output, int radius) {
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.median(input.getBand(band), ((Planar)output).getBand(band), radius);
        }
        return output;
    }

    public static GrayU8 gaussian(GrayU8 input, @Nullable GrayU8 output, double sigma, int radius, @Nullable GrayU8 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigma, radius, storage = InputSanityCheck.checkDeclare(input, storage, GrayU8.class));
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static InterleavedU8 gaussian(InterleavedU8 input, @Nullable InterleavedU8 output, double sigma, int radius, InterleavedU8 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigma, radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_S32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_S32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static GrayF32 gaussian(GrayF32 input, @Nullable GrayF32 output, double sigma, int radius, @Nullable GrayF32 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigma, radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static GrayF64 gaussian(GrayF64 input, @Nullable GrayF64 output, double sigma, int radius, @Nullable GrayF64 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigma, radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F64 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static InterleavedF32 gaussian(InterleavedF32 input, @Nullable InterleavedF32 output, double sigma, int radius, @Nullable InterleavedF32 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigma, radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F32 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F32.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static InterleavedF64 gaussian(InterleavedF64 input, @Nullable InterleavedF64 output, double sigma, int radius, @Nullable InterleavedF64 storage) {
        boolean processed = BOverrideBlurImageOps.invokeNativeGaussian(input, output = InputSanityCheck.checkDeclare(input, output), sigma, radius, storage = InputSanityCheck.checkDeclare(input, storage));
        if (!processed) {
            Kernel1D_F64 kernel = FactoryKernelGaussian.gaussian(Kernel1D_F64.class, sigma, radius);
            ConvolveImageNormalized.horizontal(kernel, input, storage);
            ConvolveImageNormalized.vertical(kernel, storage, output);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> gaussian(Planar<T> input, @Nullable Planar<T> output, double sigma, int radius, @Nullable T storage) {
        if (storage == null) {
            storage = GeneralizedImageOps.createSingleBand(input.getBandType(), input.width, input.height);
        }
        if (output == null) {
            output = input.createNew(input.width, input.height);
        }
        for (int band = 0; band < input.getNumBands(); ++band) {
            GBlurImageOps.gaussian(input.getBand(band), ((Planar)output).getBand(band), sigma, radius, storage);
        }
        return output;
    }
}

