/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.derivative.DerivativeHelperFunctions;
import boofcv.alg.filter.derivative.impl.GradientTwo1_Standard;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class GradientTwo1 {
    public static Kernel1D_S32 kernelDeriv_I32 = new Kernel1D_S32(new int[]{-1, 1}, 2, 1);
    public static Kernel1D_F32 kernelDeriv_F32 = new Kernel1D_F32(new float[]{-1.0f, 1.0f}, 2, 1);

    public static Kernel1D getKernelX(boolean isInteger) {
        if (isInteger) {
            return kernelDeriv_I32;
        }
        return kernelDeriv_F32;
    }

    public static void process(GrayU8 orig, GrayS16 derivX, GrayS16 derivY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientTwo1_Standard.process(orig, derivX, derivY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(GrayS16 orig, GrayS16 derivX, GrayS16 derivY, ImageBorder_S32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientTwo1_Standard.process(orig, derivX, derivY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_I32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_I32, border);
        }
    }

    public static void process(GrayF32 orig, GrayF32 derivX, GrayF32 derivY, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(orig, derivX, derivY);
        GradientTwo1_Standard.process(orig, derivX, derivY);
        if (border != null) {
            DerivativeHelperFunctions.processBorderHorizontal(orig, derivX, kernelDeriv_F32, border);
            DerivativeHelperFunctions.processBorderVertical(orig, derivY, kernelDeriv_F32, border);
        }
    }
}

