/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.sparse.GradientValue_I32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseTwo0_U8
implements SparseImageGradient<GrayU8, GradientValue_I32> {
    GrayU8 input;
    ImageBorder_S32<GrayU8> border;
    GradientValue_I32 gradient = new GradientValue_I32();

    public GradientSparseTwo0_U8(ImageBorder_S32<GrayU8> border) {
        this.border = border;
    }

    @Override
    public GradientValue_I32 compute(int x, int y) {
        int a01;
        int a10;
        int a00;
        if (x >= 0 && y >= 0 && x < this.input.width - 1 && y < this.input.height - 1) {
            int s = this.input.stride;
            int tl = this.input.startIndex + this.input.stride * y + x;
            a00 = this.input.data[tl] & 0xFF;
            a10 = this.input.data[tl + s] & 0xFF;
            a01 = this.input.data[tl + 1] & 0xFF;
        } else {
            a00 = this.border.get(x, y);
            a10 = this.border.get(x, y + 1);
            a01 = this.border.get(x + 1, y);
        }
        this.gradient.y = a10 - a00;
        this.gradient.x = a01 - a00;
        return this.gradient;
    }

    @Override
    public Class<GradientValue_I32> getGradientType() {
        return GradientValue_I32.class;
    }

    @Override
    public void setImage(GrayU8 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage(input);
        }
    }

    @Override
    public boolean isInBounds(int x, int y) {
        return this.border != null || x >= 0 && y >= 0 && x < this.input.width - 1 && y < this.input.height - 1;
    }
}

