/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.array.PolynomialNevilleFixed_F32;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.image.ImageGray;

public abstract class PolynomialPixel<T extends ImageGray<T>>
implements InterpolatePixelS<T> {
    protected ImageBorder<T> border;
    protected T image;
    protected int M;
    protected int offM;
    protected float[] horiz;
    protected float[] vert;
    protected float min;
    protected float max;
    protected PolynomialNevilleFixed_F32 interp1D;

    public PolynomialPixel(int maxDegree, float min, float max) {
        this.M = maxDegree;
        this.min = min;
        this.max = max;
        this.horiz = new float[maxDegree];
        this.vert = new float[maxDegree];
        this.offM = maxDegree % 2 == 0 ? 1 : 0;
        this.interp1D = new PolynomialNevilleFixed_F32(maxDegree);
    }

    @Override
    public void setBorder(ImageBorder<T> border) {
        this.border = border;
    }

    @Override
    public void setImage(T image) {
        if (this.border != null) {
            this.border.setImage(image);
        }
        this.image = image;
    }

    @Override
    public T getImage() {
        return this.image;
    }

    @Override
    public boolean isInFastBounds(float x, float y) {
        float x0 = x - (float)(this.M / 2) + (float)this.offM;
        float x1 = x0 + (float)this.M;
        float y0 = y - (float)(this.M / 2) + (float)this.offM;
        float y1 = y0 + (float)this.M;
        return x0 >= 0.0f && y0 >= 0.0f && x1 <= (float)(((ImageGray)this.image).width - 1) && y1 <= (float)(((ImageGray)this.image).height - 1);
    }

    @Override
    public int getFastBorderX() {
        return this.M;
    }

    @Override
    public int getFastBorderY() {
        return this.M;
    }

    @Override
    public ImageBorder<T> getBorder() {
        return this.border;
    }
}

