/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ImplConvertImage {
    public static void convert(GrayU8 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)(from.data[indexFrom++] & 0xFF);
                }
            }
        } else {
            int N = from.width * from.height;
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(InterleavedU8 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)(from.data[indexFrom++] & 0xFF);
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(GrayU8 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (short)(from.data[indexFrom++] & 0xFF);
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)(from.data[i] & 0xFF);
            }
        }
    }

    public static void convert(InterleavedU8 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (short)(from.data[indexFrom++] & 0xFF);
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)(from.data[i] & 0xFF);
            }
        }
    }

    public static void convert(GrayU8 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(InterleavedU8 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(GrayU8 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(InterleavedU8 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(GrayU8 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(InterleavedU8 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(GrayU8 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(InterleavedU8 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFF;
            }
        }
    }

    public static void convert(InterleavedU8 input, Planar<GrayU8> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayU8 band = ((GrayU8[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayU8> input, InterleavedU8 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayU8 band = ((GrayU8[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayS8 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(InterleavedS8 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(GrayS8 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS8 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS8 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS8 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS8 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS8 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS8 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS8 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS8 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS8 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS8 input, Planar<GrayS8> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayS8 band = ((GrayS8[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayS8> input, InterleavedS8 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayS8 band = ((GrayS8[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayU16 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)(from.data[indexFrom++] & 0xFFFF);
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)(from.data[i] & 0xFFFF);
            }
        }
    }

    public static void convert(InterleavedU16 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)(from.data[indexFrom++] & 0xFFFF);
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)(from.data[i] & 0xFFFF);
            }
        }
    }

    public static void convert(GrayU16 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (short)(from.data[indexFrom++] & 0xFFFF);
                }
            }
        } else {
            int N = from.width * from.height;
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(InterleavedU16 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (short)(from.data[indexFrom++] & 0xFFFF);
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(GrayU16 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(InterleavedU16 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(GrayU16 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(InterleavedU16 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(GrayU16 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(InterleavedU16 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(GrayU16 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(InterleavedU16 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++] & 0xFFFF;
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i] & 0xFFFF;
            }
        }
    }

    public static void convert(InterleavedU16 input, Planar<GrayU16> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayU16 band = ((GrayU16[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayU16> input, InterleavedU16 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayU16 band = ((GrayU16[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayS16 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(InterleavedS16 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(GrayS16 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(InterleavedS16 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            System.arraycopy(from.data, 0, to.data, 0, N);
        }
    }

    public static void convert(GrayS16 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS16 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS16 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS16 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS16 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS16 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS16 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS16 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS16 input, Planar<GrayS16> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayS16 band = ((GrayS16[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayS16> input, InterleavedS16 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayS16 band = ((GrayS16[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayS32 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(InterleavedS32 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(GrayS32 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(InterleavedS32 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(GrayS32 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS32 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS32 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS32 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS32 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS32 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS32 input, Planar<GrayS32> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayS32 band = ((GrayS32[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayS32> input, InterleavedS32 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayS32 band = ((GrayS32[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayS64 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(InterleavedS64 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(GrayS64 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(InterleavedS64 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(GrayS64 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (int)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (int)from.data[i];
            }
        }
    }

    public static void convert(InterleavedS64 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (int)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (int)from.data[i];
            }
        }
    }

    public static void convert(GrayS64 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS64 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(GrayS64 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS64 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedS64 input, Planar<GrayS64> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayS64 band = ((GrayS64[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayS64> input, InterleavedS64 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayS64 band = ((GrayS64[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayF32 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF32 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(GrayF32 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF32 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(GrayF32 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (int)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (int)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF32 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (int)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (int)from.data[i];
            }
        }
    }

    public static void convert(GrayF32 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (long)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (long)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF32 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (long)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (long)from.data[i];
            }
        }
    }

    public static void convert(GrayF32 from, GrayF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedF32 from, InterleavedF64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = from.data[i];
            }
        }
    }

    public static void convert(InterleavedF32 input, Planar<GrayF32> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayF32 band = ((GrayF32[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayF32> input, InterleavedF32 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayF32 band = ((GrayF32[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }

    public static void convert(GrayF64 from, GrayI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF64 from, InterleavedI8 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (byte)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (byte)from.data[i];
            }
        }
    }

    public static void convert(GrayF64 from, GrayI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF64 from, InterleavedI16 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (short)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (short)from.data[i];
            }
        }
    }

    public static void convert(GrayF64 from, GrayS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (int)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (int)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF64 from, InterleavedS32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (int)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (int)from.data[i];
            }
        }
    }

    public static void convert(GrayF64 from, GrayS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (long)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (long)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF64 from, InterleavedS64 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (long)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (long)from.data[i];
            }
        }
    }

    public static void convert(GrayF64 from, GrayF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < from.width; ++x) {
                    to.data[indexTo++] = (float)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height;
            for (int i = 0; i < N; ++i) {
                to.data[i] = (float)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF64 from, InterleavedF32 to) {
        if (from.isSubimage() || to.isSubimage()) {
            int N = from.width * from.getNumBands();
            for (int y = 0; y < from.height; ++y) {
                int indexFrom = from.getIndex(0, y);
                int indexTo = to.getIndex(0, y);
                for (int x = 0; x < N; ++x) {
                    to.data[indexTo++] = (float)from.data[indexFrom++];
                }
            }
        } else {
            int N = from.width * from.height * from.getNumBands();
            for (int i = 0; i < N; ++i) {
                to.data[i] = (float)from.data[i];
            }
        }
    }

    public static void convert(InterleavedF64 input, Planar<GrayF64> output) {
        int numBands = input.numBands;
        for (int i = 0; i < numBands; ++i) {
            GrayF64 band = ((GrayF64[])output.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex + i;
                int indexDst = y * output.stride + output.startIndex;
                int end = indexDst + input.width;
                while (indexDst != end) {
                    band.data[indexDst++] = input.data[indexSrc];
                    indexSrc += numBands;
                }
            }
        }
    }

    public static void convert(Planar<GrayF64> input, InterleavedF64 output) {
        int numBands = input.getNumBands();
        for (int i = 0; i < numBands; ++i) {
            GrayF64 band = ((GrayF64[])input.bands)[i];
            for (int y = 0; y < input.height; ++y) {
                int indexSrc = y * input.stride + input.startIndex;
                int indexDst = y * output.stride + output.startIndex + i;
                int end = indexSrc + input.width;
                while (indexSrc != end) {
                    output.data[indexDst] = band.data[indexSrc++];
                    indexDst += numBands;
                }
            }
        }
    }
}

