/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

public class MovingAverage {
    double decay;
    double average;
    boolean first;

    public MovingAverage() {
        this(0.95);
    }

    public MovingAverage(double decay) {
        if (decay < 0.0 || decay > 1.0) {
            throw new IllegalArgumentException("Decay must be 0 to 1, inclusive");
        }
        this.decay = decay;
        this.reset();
    }

    public void reset() {
        this.first = true;
    }

    public double update(double sample) {
        if (this.first) {
            this.first = false;
            this.average = sample;
        } else {
            this.average = this.average * this.decay + (1.0 - this.decay) * sample;
        }
        return this.average;
    }

    public double getAverage() {
        return this.average;
    }
}

