/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.Configuration;

public class ConfigLength
implements Configuration {
    public double length = -1.0;
    public double fraction = -1.0;

    public ConfigLength(double length, double fraction) {
        this.length = length;
        this.fraction = fraction;
    }

    public ConfigLength() {
    }

    public static ConfigLength fixed(double pixels) {
        return new ConfigLength(pixels, -1.0);
    }

    public static ConfigLength relative(double fraction, int minimum) {
        return new ConfigLength(minimum, fraction);
    }

    public double compute(double totalLength) {
        double size;
        if (this.fraction >= 0.0) {
            size = this.fraction * totalLength;
            size = Math.max(size, this.length);
        } else {
            size = this.length;
        }
        return size;
    }

    public boolean isRelative() {
        return this.fraction >= 0.0;
    }

    public boolean isFixed() {
        return this.fraction < 0.0;
    }

    public int computeI(double totalLength) {
        double size = this.compute(totalLength);
        if (size >= 0.0) {
            return (int)(size + 0.5);
        }
        return -1;
    }

    public int getLengthI() {
        return (int)(this.length + 0.5);
    }

    @Override
    public void checkValidity() {
        if (this.length < 0.0 && this.fraction < 0.0) {
            throw new IllegalArgumentException("length and/or fraction must be >= 0");
        }
    }

    public ConfigLength copy() {
        return new ConfigLength(this.length, this.fraction);
    }

    public String toString() {
        String out = "ConfigLength{";
        out = this.fraction >= 0.0 ? out + "fraction=" + this.fraction + ", minimum=" + this.length : out + ", length=" + this.length;
        out = out + '}';
        return out;
    }
}

