/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.blur;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class BlurStorageFilter<T extends ImageBase<T>>
implements BlurFilter<T> {
    private BlurOperation operation;
    private double sigma;
    private int radius;
    private T storage;
    ImageType<T> inputType;

    public BlurStorageFilter(String functionName, ImageType<T> inputType, int radius) {
        this(functionName, inputType, -1.0, radius);
    }

    public BlurStorageFilter(String functionName, ImageType<T> inputType, double sigma, int radius) {
        this.radius = radius;
        this.sigma = sigma;
        this.inputType = inputType;
        if (functionName.equals("mean")) {
            this.operation = new MeanOperation();
            this.createStorage();
        } else if (functionName.equals("gaussian")) {
            this.operation = new GaussianOperation();
            this.createStorage();
        } else if (functionName.equals("median")) {
            this.operation = new MedianOperator();
        } else {
            throw new IllegalArgumentException("Unknown function " + functionName);
        }
    }

    private void createStorage() {
        this.storage = this.inputType.getFamily() == ImageType.Family.PLANAR ? GeneralizedImageOps.createSingleBand(this.inputType.getImageClass(), 1, 1) : this.inputType.createImage(1, 1);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(int radius) {
        this.radius = radius;
    }

    @Override
    public void process(T input, T output) {
        if (this.storage != null) {
            ((ImageBase)this.storage).reshape(((ImageBase)output).width, ((ImageBase)output).height);
        }
        this.operation.process((ImageBase)input, (ImageBase)output);
    }

    @Override
    public int getHorizontalBorder() {
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return 0;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<T> getOutputType() {
        return this.inputType;
    }

    private class MedianOperator
    implements BlurOperation {
        private MedianOperator() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.median(input, output, BlurStorageFilter.this.radius);
        }
    }

    private class GaussianOperation
    implements BlurOperation {
        private GaussianOperation() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.gaussian(input, output, BlurStorageFilter.this.sigma, BlurStorageFilter.this.radius, BlurStorageFilter.this.storage);
        }
    }

    private class MeanOperation
    implements BlurOperation {
        private MeanOperation() {
        }

        @Override
        public void process(ImageBase input, ImageBase output) {
            GBlurImageOps.mean(input, output, BlurStorageFilter.this.radius, BlurStorageFilter.this.storage);
        }
    }

    private static interface BlurOperation {
        public void process(ImageBase var1, ImageBase var2);
    }
}

