/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ColorRgb {
    public static int rgbToGray_Weighted(int r, int g, int b) {
        return (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
    }

    public static float rgbToGray_Weighted(float r, float g, float b) {
        return 0.299f * r + 0.587f * g + 0.114f * b;
    }

    public static double rgbToGray_Weighted(double r, double g, double b) {
        return 0.299 * r + 0.587 * g + 0.114 * b;
    }

    public static void rgbToGray_Weighted(ImageMultiBand rgb, ImageGray gray) {
        gray.reshape(rgb.width, rgb.height);
        if (rgb instanceof Planar) {
            Planar p = (Planar)rgb;
            if (p.getBandType() == GrayU8.class) {
                ColorRgb.rgbToGray_Weighted_U8(p, (GrayU8)gray);
                return;
            }
            if (p.getBandType() == GrayF32.class) {
                ColorRgb.rgbToGray_Weighted_F32(p, (GrayF32)gray);
                return;
            }
            if (p.getBandType() == GrayF64.class) {
                ColorRgb.rgbToGray_Weighted_F64(p, (GrayF64)gray);
                return;
            }
        } else if (rgb instanceof ImageInterleaved) {
            if (rgb instanceof InterleavedU8) {
                ColorRgb.rgbToGray_Weighted((InterleavedU8)rgb, (GrayU8)gray);
                return;
            }
            if (rgb instanceof InterleavedF32) {
                ColorRgb.rgbToGray_Weighted((InterleavedF32)rgb, (GrayF32)gray);
                return;
            }
            if (rgb instanceof InterleavedF64) {
                ColorRgb.rgbToGray_Weighted((InterleavedF64)rgb, (GrayF64)gray);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static void rgbToGray_Weighted_U8(Planar<GrayU8> rgb, GrayU8 gray) {
        GrayU8 R = rgb.getBand(0);
        GrayU8 G = rgb.getBand(1);
        GrayU8 B = rgb.getBand(2);
        for (int row = 0; row < rgb.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indedGra = gray.startIndex + row * gray.stride;
            int col = 0;
            while (col < rgb.width) {
                double r = R.data[indexRgb] & 0xFF;
                double g = G.data[indexRgb] & 0xFF;
                double b = B.data[indexRgb] & 0xFF;
                gray.data[indedGra] = (byte)(0.299 * r + 0.587 * g + 0.114 * b);
                ++col;
                ++indedGra;
                ++indexRgb;
            }
        }
    }

    public static void rgbToGray_Weighted_F32(Planar<GrayF32> rgb, GrayF32 gray) {
        GrayF32 R = rgb.getBand(0);
        GrayF32 G = rgb.getBand(1);
        GrayF32 B = rgb.getBand(2);
        for (int row = 0; row < rgb.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indedGra = gray.startIndex + row * gray.stride;
            int col = 0;
            while (col < rgb.width) {
                float r = R.data[indexRgb];
                float g = G.data[indexRgb];
                float b = B.data[indexRgb];
                gray.data[indedGra] = 0.299f * r + 0.587f * g + 0.114f * b;
                ++col;
                ++indedGra;
                ++indexRgb;
            }
        }
    }

    public static void rgbToGray_Weighted_F64(Planar<GrayF64> rgb, GrayF64 gray) {
        GrayF64 R = rgb.getBand(0);
        GrayF64 G = rgb.getBand(1);
        GrayF64 B = rgb.getBand(2);
        for (int row = 0; row < rgb.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indedGra = gray.startIndex + row * gray.stride;
            int col = 0;
            while (col < rgb.width) {
                double r = R.data[indexRgb];
                double g = G.data[indexRgb];
                double b = B.data[indexRgb];
                gray.data[indedGra] = 0.299 * r + 0.587 * g + 0.114 * b;
                ++col;
                ++indedGra;
                ++indexRgb;
            }
        }
    }

    public static void rgbToGray_Weighted(InterleavedU8 rgb, GrayU8 gray) {
        for (int row = 0; row < rgb.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indedGra = gray.startIndex + row * gray.stride;
            int col = 0;
            while (col < rgb.width) {
                double r = rgb.data[indexRgb++] & 0xFF;
                double g = rgb.data[indexRgb++] & 0xFF;
                double b = rgb.data[indexRgb++] & 0xFF;
                gray.data[indedGra] = (byte)(0.299 * r + 0.587 * g + 0.114 * b);
                ++col;
                ++indedGra;
            }
        }
    }

    public static void rgbToGray_Weighted(InterleavedF32 rgb, GrayF32 gray) {
        for (int row = 0; row < rgb.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indedGra = gray.startIndex + row * gray.stride;
            int col = 0;
            while (col < rgb.width) {
                float r = rgb.data[indexRgb++];
                float g = rgb.data[indexRgb++];
                float b = rgb.data[indexRgb++];
                gray.data[indedGra] = 0.299f * r + 0.587f * g + 0.114f * b;
                ++col;
                ++indedGra;
            }
        }
    }

    public static void rgbToGray_Weighted(InterleavedF64 rgb, GrayF64 gray) {
        for (int row = 0; row < rgb.height; ++row) {
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int indedGra = gray.startIndex + row * gray.stride;
            int col = 0;
            while (col < rgb.width) {
                double r = rgb.data[indexRgb++];
                double g = rgb.data[indexRgb++];
                double b = rgb.data[indexRgb++];
                gray.data[indedGra] = 0.299 * r + 0.587 * g + 0.114 * b;
                ++col;
                ++indedGra;
            }
        }
    }
}

