/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.GradientTwo0;
import boofcv.alg.filter.derivative.GradientTwo1;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class GImageDerivativeOps {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> void laplace(I input, D output) {
        if (input instanceof GrayF32) {
            LaplacianEdge.process((GrayF32)input, (GrayF32)output);
        } else if (input instanceof GrayU8) {
            LaplacianEdge.process((GrayU8)input, (GrayS16)output);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> Class<D> getDerivativeType(Class<I> imageType) {
        if (imageType == GrayF32.class) {
            return GrayF32.class;
        }
        if (imageType == GrayU8.class) {
            return GrayS16.class;
        }
        if (imageType == GrayU16.class) {
            return GrayS32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + imageType.getSimpleName());
    }

    public static <I extends ImageBase<I>, D extends ImageBase<D>> ImageType<D> getDerivativeType(ImageType<I> imageType) {
        switch (imageType.getFamily()) {
            case GRAY: {
                return ImageType.single(GImageDerivativeOps.getDerivativeType(imageType.getImageClass()));
            }
            case PLANAR: {
                int numBands = imageType.getNumBands();
                return ImageType.pl(numBands, GImageDerivativeOps.getDerivativeType(imageType.getImageClass()));
            }
            case INTERLEAVED: {
                int numBands = imageType.getNumBands();
                switch (imageType.getDataType()) {
                    case F32: {
                        return ImageType.il(numBands, ImageDataType.F32);
                    }
                    case F64: {
                        return ImageType.il(numBands, ImageDataType.F64);
                    }
                    case U8: {
                        return ImageType.il(numBands, ImageDataType.S16);
                    }
                    case U16: {
                        return ImageType.il(numBands, ImageDataType.S32);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> void gradient(DerivativeType type, I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, input);
        switch (type) {
            case PREWITT: {
                if (input instanceof GrayF32) {
                    GradientPrewitt.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientPrewitt.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientPrewitt.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case SOBEL: {
                if (input instanceof GrayF32) {
                    GradientSobel.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientSobel.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientSobel.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case THREE: {
                if (input instanceof GrayF32) {
                    GradientThree.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientThree.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientThree.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case TWO_0: {
                if (input instanceof GrayF32) {
                    GradientTwo0.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientTwo0.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientTwo0.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case TWO_1: {
                if (input instanceof GrayF32) {
                    GradientTwo1.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientTwo1.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientTwo1.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
            }
        }
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> void hessian(DerivativeType type, I input, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<I> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, input);
        switch (type) {
            case SOBEL: {
                if (input instanceof GrayF32) {
                    HessianSobel.process((GrayF32)input, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    HessianSobel.process((GrayU8)input, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case THREE: {
                if (input instanceof GrayF32) {
                    HessianThree.process((GrayF32)input, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    HessianThree.process((GrayU8)input, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unsupported derivative type " + (Object)((Object)type));
            }
        }
    }

    public static <D extends ImageGray<D>> void hessian(DerivativeType type, D derivX, D derivY, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<D> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, derivX);
        switch (type) {
            case PREWITT: {
                if (derivX instanceof GrayF32) {
                    HessianFromGradient.hessianPrewitt((GrayF32)derivX, (GrayF32)derivY, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof GrayS16) {
                    HessianFromGradient.hessianPrewitt((GrayS16)derivX, (GrayS16)derivY, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            case SOBEL: {
                if (derivX instanceof GrayF32) {
                    HessianFromGradient.hessianSobel((GrayF32)derivX, (GrayF32)derivY, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof GrayS16) {
                    HessianFromGradient.hessianSobel((GrayS16)derivX, (GrayS16)derivY, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            case THREE: {
                if (derivX instanceof GrayF32) {
                    HessianFromGradient.hessianThree((GrayF32)derivX, (GrayF32)derivY, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof GrayS16) {
                    HessianFromGradient.hessianThree((GrayS16)derivX, (GrayS16)derivY, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unsupported derivative type " + (Object)((Object)type));
            }
        }
    }

    public static KernelBase lookupKernelX(DerivativeType type, boolean isInteger) {
        switch (type) {
            case PREWITT: {
                return GradientPrewitt.getKernelX(isInteger);
            }
            case SOBEL: {
                return GradientSobel.getKernelX(isInteger);
            }
            case THREE: {
                return GradientThree.getKernelX(isInteger);
            }
            case TWO_0: {
                return GradientTwo0.getKernelX(isInteger);
            }
            case TWO_1: {
                return GradientTwo1.getKernelX(isInteger);
            }
        }
        throw new IllegalArgumentException("Unknown kernel type: " + (Object)((Object)type));
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> AnyImageDerivative<I, D> createAnyDerivatives(DerivativeType type, Class<I> inputType, Class<D> derivType) {
        boolean isInteger = !GeneralizedImageOps.isFloatingPoint(inputType);
        KernelBase kernel = GImageDerivativeOps.lookupKernelX(type, isInteger);
        if (kernel instanceof Kernel1D) {
            return new AnyImageDerivative<I, D>((Kernel1D)kernel, inputType, derivType);
        }
        return new AnyImageDerivative<I, D>((Kernel2D)kernel, inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> AnyImageDerivative<I, D> derivativeForScaleSpace(Class<I> inputType, Class<D> derivType) {
        return GImageDerivativeOps.createAnyDerivatives(DerivativeType.THREE, inputType, derivType);
    }
}

