/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.enhance;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class GEnhanceImageOps {
    public static <T extends ImageGray<T>> void applyTransform(T input, int[] transform, int minValue, T output) {
        InputSanityCheck.checkSameShape(input, output);
        if (input instanceof GrayU8) {
            EnhanceImageOps.applyTransform((GrayU8)input, transform, (GrayU8)output);
        } else if (input instanceof GrayS8) {
            EnhanceImageOps.applyTransform((GrayS8)input, transform, minValue, (GrayS8)output);
        } else if (input instanceof GrayU16) {
            EnhanceImageOps.applyTransform((GrayU16)input, transform, (GrayU16)output);
        } else if (input instanceof GrayS16) {
            EnhanceImageOps.applyTransform((GrayS16)input, transform, minValue, (GrayS16)output);
        } else if (input instanceof GrayS32) {
            EnhanceImageOps.applyTransform((GrayS32)input, transform, minValue, (GrayS32)output);
        } else {
            throw new IllegalArgumentException("Image type not supported. " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void equalizeLocal(T input, int radius, T output, int[] histogram, int[] transform) {
        if (input instanceof GrayU8) {
            EnhanceImageOps.equalizeLocal((GrayU8)input, radius, (GrayU8)output, histogram, transform);
        } else if (input instanceof GrayU16) {
            EnhanceImageOps.equalizeLocal((GrayU16)input, radius, (GrayU16)output, histogram, transform);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void sharpen4(T input, T output) {
        if (input instanceof GrayU8) {
            EnhanceImageOps.sharpen4((GrayU8)input, (GrayU8)output);
        } else if (input instanceof GrayF32) {
            EnhanceImageOps.sharpen4((GrayF32)input, (GrayF32)output);
        } else {
            throw new IllegalArgumentException("Image type not supported. " + input.getClass().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void sharpen8(T input, T output) {
        if (input instanceof GrayU8) {
            EnhanceImageOps.sharpen8((GrayU8)input, (GrayU8)output);
        } else if (input instanceof GrayF32) {
            EnhanceImageOps.sharpen8((GrayF32)input, (GrayF32)output);
        } else {
            throw new IllegalArgumentException("Image type not supported. " + input.getClass().getSimpleName());
        }
    }
}

