/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.InputSanityCheck;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public abstract class ThresholdBlockCommon<T extends ImageGray<T>, S extends ImageBase<S>>
implements InputToBinary<T> {
    ImageType<T> imageType;
    protected S stats;
    protected ConfigLength requestedBlockWidth;
    protected int blockWidth;
    protected int blockHeight;
    protected boolean thresholdFromLocalBlocks;

    public ThresholdBlockCommon(ConfigLength requestedBlockWidth, boolean thresholdFromLocalBlocks, Class<T> imageClass) {
        this.requestedBlockWidth = requestedBlockWidth;
        this.imageType = ImageType.single(imageClass);
        this.thresholdFromLocalBlocks = thresholdFromLocalBlocks;
    }

    @Override
    public void process(T input, GrayU8 output) {
        InputSanityCheck.checkSameShape(input, output);
        int requestedBlockWidth = this.requestedBlockWidth.computeI(Math.min(((ImageGray)input).width, ((ImageGray)input).height));
        if (((ImageGray)input).width < requestedBlockWidth || ((ImageGray)input).height < requestedBlockWidth) {
            throw new IllegalArgumentException("Image is smaller than block size");
        }
        this.selectBlockSize(((ImageGray)input).width, ((ImageGray)input).height, requestedBlockWidth);
        ((ImageBase)this.stats).reshape(((ImageGray)input).width / this.blockWidth, ((ImageGray)input).height / this.blockHeight);
        int innerWidth = ((ImageGray)input).width % this.blockWidth == 0 ? ((ImageGray)input).width : ((ImageGray)input).width - this.blockWidth - ((ImageGray)input).width % this.blockWidth;
        int innerHeight = ((ImageGray)input).height % this.blockHeight == 0 ? ((ImageGray)input).height : ((ImageGray)input).height - this.blockHeight - ((ImageGray)input).height % this.blockHeight;
        this.computeStatistics(input, innerWidth, innerHeight);
        this.applyThreshold(input, output);
    }

    void selectBlockSize(int width, int height, int requestedBlockWidth) {
        int rows = height / requestedBlockWidth;
        int cols = width / requestedBlockWidth;
        this.blockHeight = height / rows;
        this.blockWidth = width / cols;
    }

    private void applyThreshold(T input, GrayU8 output) {
        for (int blockY = 0; blockY < ((ImageBase)this.stats).height; ++blockY) {
            for (int blockX = 0; blockX < ((ImageBase)this.stats).width; ++blockX) {
                this.thresholdBlock(blockX, blockY, input, output);
            }
        }
    }

    protected void computeStatistics(T input, int innerWidth, int innerHeight) {
        int y;
        int statPixelStride = ((ImageBase)this.stats).getImageType().getNumBands();
        int indexStats = 0;
        for (y = 0; y < innerHeight; y += this.blockHeight) {
            int x = 0;
            while (x < innerWidth) {
                this.computeBlockStatistics(x, y, this.blockWidth, this.blockHeight, indexStats, input);
                x += this.blockWidth;
                indexStats += statPixelStride;
            }
            if (innerWidth == ((ImageGray)input).width) continue;
            this.computeBlockStatistics(innerWidth, y, ((ImageGray)input).width - innerWidth, this.blockHeight, indexStats, input);
            indexStats += statPixelStride;
        }
        if (innerHeight != ((ImageGray)input).height) {
            y = innerHeight;
            int blockHeight = ((ImageGray)input).height - innerHeight;
            int x = 0;
            while (x < innerWidth) {
                this.computeBlockStatistics(x, y, this.blockWidth, blockHeight, indexStats, input);
                x += this.blockWidth;
                indexStats += statPixelStride;
            }
            if (innerWidth != ((ImageGray)input).width) {
                this.computeBlockStatistics(innerWidth, y, ((ImageGray)input).width - innerWidth, blockHeight, indexStats, input);
            }
        }
    }

    protected abstract void computeBlockStatistics(int var1, int var2, int var3, int var4, int var5, T var6);

    protected abstract void thresholdBlock(int var1, int var2, T var3, GrayU8 var4);

    public boolean isThresholdFromLocalBlocks() {
        return this.thresholdFromLocalBlocks;
    }

    public void setThresholdFromLocalBlocks(boolean thresholdFromLocalBlocks) {
        this.thresholdFromLocalBlocks = thresholdFromLocalBlocks;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }
}

