/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdBlockMean;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;

public class ThresholdBlockMean_F32
extends ThresholdBlockMean<GrayF32> {
    float scale;
    boolean down;

    public ThresholdBlockMean_F32(ConfigLength requestedBlockWidth, double scale, boolean down, boolean thresholdFromLocalBlocks) {
        super(requestedBlockWidth, thresholdFromLocalBlocks, GrayF32.class);
        this.stats = new GrayF32(1, 1);
        this.scale = (float)scale;
        this.down = down;
    }

    @Override
    protected void thresholdBlock(int blockX0, int blockY0, GrayF32 input, GrayU8 output) {
        byte b;
        byte a;
        int blockY1;
        int blockX1;
        int y1;
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == ((GrayF32)this.stats).width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int n = y1 = blockY0 == ((GrayF32)this.stats).height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        if (this.thresholdFromLocalBlocks) {
            blockX1 = Math.min(((GrayF32)this.stats).width - 1, blockX0 + 1);
            blockY1 = Math.min(((GrayF32)this.stats).height - 1, blockY0 + 1);
            blockX0 = Math.max(0, blockX0 - 1);
            blockY0 = Math.max(0, blockY0 - 1);
        } else {
            blockX1 = blockX0;
            blockY1 = blockY0;
        }
        float mean = 0.0f;
        for (int y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                mean += ((GrayF32)this.stats).unsafe_get(x, y);
            }
        }
        mean /= (float)((blockY1 - blockY0 + 1) * (blockX1 - blockX0 + 1));
        if (this.down) {
            a = 1;
            b = 0;
        } else {
            a = 0;
            b = 1;
        }
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int end = indexOutput + (x1 - x0);
            while (indexOutput < end) {
                output.data[indexOutput] = input.data[indexInput] <= mean ? a : b;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    protected void computeBlockStatistics(int x0, int y0, int width, int height, int indexStats, GrayF32 input) {
        float sum = 0.0f;
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                sum += input.data[indexInput++];
            }
        }
        ((GrayF32)this.stats).data[indexStats] = sum = this.scale * sum / (float)(width * height);
    }
}

