/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.filter.convolve.ConvolveImage;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.ConvolveImageNormalized;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_IL_F32;
import boofcv.core.image.border.ImageBorder_IL_S32;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class GConvolveImageOps {
    public static <In extends ImageBase<In>, Out extends ImageBase<Out>, K extends Kernel1D, B extends ImageBorder<In>> void horizontal(K kernel, In input, Out output, B border) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImage.horizontal((Kernel1D_F32)kernel, (GrayF32)input, (GrayF32)output, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    if (GrayI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImage.horizontal((Kernel1D_S32)kernel, (GrayU8)input, (GrayI16)output, (ImageBorder_S32)border);
                        break;
                    }
                    ConvolveImage.horizontal((Kernel1D_S32)kernel, (GrayU8)input, (GrayS32)output, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImage.horizontal((Kernel1D_S32)kernel, (GrayS16)input, (GrayI16)output, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedF32) {
                    ConvolveImage.horizontal((Kernel1D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output, (ImageBorder_IL_F32)border);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImage.horizontal((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedI16)output, (ImageBorder_IL_S32)border);
                        break;
                    }
                    ConvolveImage.horizontal((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedS32)output, (ImageBorder_IL_S32)border);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImage.horizontal((Kernel1D_S32)kernel, (InterleavedS16)input, (InterleavedI16)((InterleavedU16)output), (ImageBorder_IL_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.horizontal(kernel, inp.getBand(i), outp.getBand(i), border);
                }
                break;
            }
        }
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>, K extends Kernel1D, B extends ImageBorder<In>> void vertical(K kernel, In input, Out output, B border) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImage.vertical((Kernel1D_F32)kernel, (GrayF32)input, (GrayF32)output, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    if (GrayI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImage.vertical((Kernel1D_S32)kernel, (GrayU8)input, (GrayI16)output, (ImageBorder_S32)border);
                        break;
                    }
                    ConvolveImage.vertical((Kernel1D_S32)kernel, (GrayU8)input, (GrayS32)output, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImage.vertical((Kernel1D_S32)kernel, (GrayS16)input, (GrayI16)output, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedF32) {
                    ConvolveImage.vertical((Kernel1D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output, (ImageBorder_IL_F32)border);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImage.vertical((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedI16)output, (ImageBorder_IL_S32)border);
                        break;
                    }
                    ConvolveImage.vertical((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedS32)output, (ImageBorder_IL_S32)border);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImage.vertical((Kernel1D_S32)kernel, (InterleavedS16)input, (InterleavedI16)((InterleavedU16)output), (ImageBorder_IL_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.vertical(kernel, inp.getBand(i), outp.getBand(i), border);
                }
                break;
            }
        }
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>, K extends Kernel2D, B extends ImageBorder<In>> void convolve(K kernel, In input, Out output, B border) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImage.convolve((Kernel2D_F32)kernel, (GrayF32)input, (GrayF32)output, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    if (GrayI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImage.convolve((Kernel2D_S32)kernel, (GrayU8)input, (GrayI16)output, (ImageBorder_S32)border);
                        break;
                    }
                    ConvolveImage.convolve((Kernel2D_S32)kernel, (GrayU8)input, (GrayS32)output, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImage.convolve((Kernel2D_S32)kernel, (GrayS16)input, (GrayI16)output, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedF32) {
                    ConvolveImage.convolve((Kernel2D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output, (ImageBorder_IL_F32)border);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImage.convolve((Kernel2D_S32)kernel, (InterleavedU8)input, (InterleavedI16)output, (ImageBorder_IL_S32)border);
                        break;
                    }
                    ConvolveImage.convolve((Kernel2D_S32)kernel, (InterleavedU8)input, (InterleavedS32)output, (ImageBorder_IL_S32)border);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImage.convolve((Kernel2D_S32)kernel, (InterleavedS16)input, (InterleavedI16)((InterleavedU16)output), (ImageBorder_IL_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.convolve(kernel, inp.getBand(i), outp.getBand(i), border);
                }
                break;
            }
        }
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>, K extends Kernel1D> void horizontal(K kernel, In input, Out output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImageNoBorder.horizontal((Kernel1D_F32)kernel, (GrayF32)input, (GrayF32)output);
                    break;
                }
                if (input instanceof GrayU8) {
                    if (GrayI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImageNoBorder.horizontal((Kernel1D_S32)kernel, (GrayU8)input, (GrayI16)output);
                        break;
                    }
                    ConvolveImageNoBorder.horizontal((Kernel1D_S32)kernel, (GrayU8)input, (GrayS32)output);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImageNoBorder.horizontal((Kernel1D_S32)kernel, (GrayS16)input, (GrayI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (output instanceof InterleavedF32) {
                    ConvolveImageNoBorder.horizontal((Kernel1D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImageNoBorder.horizontal((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedI16)output);
                        break;
                    }
                    ConvolveImageNoBorder.horizontal((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedS32)output);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImageNoBorder.horizontal((Kernel1D_S32)kernel, (InterleavedS16)input, (InterleavedI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.horizontal(kernel, inp.getBand(i), outp.getBand(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image family");
            }
        }
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>, K extends Kernel1D> void vertical(K kernel, In input, Out output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImageNoBorder.vertical((Kernel1D_F32)kernel, (GrayF32)input, (GrayF32)output);
                    break;
                }
                if (input instanceof GrayU8) {
                    if (GrayI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImageNoBorder.vertical((Kernel1D_S32)kernel, (GrayU8)input, (GrayI16)output);
                        break;
                    }
                    ConvolveImageNoBorder.vertical((Kernel1D_S32)kernel, (GrayU8)input, (GrayS32)output);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImageNoBorder.vertical((Kernel1D_S32)kernel, (GrayS16)input, (GrayI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (output instanceof InterleavedF32) {
                    ConvolveImageNoBorder.vertical((Kernel1D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImageNoBorder.vertical((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedI16)output);
                        break;
                    }
                    ConvolveImageNoBorder.vertical((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedS32)output);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImageNoBorder.vertical((Kernel1D_S32)kernel, (InterleavedS16)input, (InterleavedI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.vertical(kernel, inp.getBand(i), outp.getBand(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image family");
            }
        }
    }

    public static <In extends ImageBase<In>, Out extends ImageBase<Out>, K extends Kernel2D> void convolve(K kernel, In input, Out output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImageNoBorder.convolve((Kernel2D_F32)kernel, (GrayF32)input, (GrayF32)output);
                    break;
                }
                if (input instanceof GrayU8) {
                    if (GrayI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImageNoBorder.convolve((Kernel2D_S32)kernel, (GrayU8)input, (GrayI16)output);
                        break;
                    }
                    ConvolveImageNoBorder.convolve((Kernel2D_S32)kernel, (GrayU8)input, (GrayS32)output);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImageNoBorder.convolve((Kernel2D_S32)kernel, (GrayS16)input, (GrayI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (output instanceof InterleavedF32) {
                    ConvolveImageNoBorder.convolve((Kernel2D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                        ConvolveImageNoBorder.convolve((Kernel2D_S32)kernel, (InterleavedU8)input, (InterleavedI16)output);
                        break;
                    }
                    ConvolveImageNoBorder.convolve((Kernel2D_S32)kernel, (InterleavedU8)input, (InterleavedS32)output);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImageNoBorder.convolve((Kernel2D_S32)kernel, (InterleavedS16)input, (InterleavedI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.convolve(kernel, inp.getBand(i), outp.getBand(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image family");
            }
        }
    }

    public static <In extends ImageBase, Out extends ImageBase, K extends Kernel1D> void horizontalNormalized(K kernel, In input, Out output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImageNormalized.horizontal((Kernel1D_F32)kernel, (GrayF32)input, (GrayF32)output);
                    break;
                }
                if (input instanceof GrayF64) {
                    ConvolveImageNormalized.horizontal((Kernel1D_F64)kernel, (GrayF64)input, (GrayF64)output);
                    break;
                }
                if (input instanceof GrayU8) {
                    ConvolveImageNormalized.horizontal((Kernel1D_S32)kernel, (GrayU8)input, (GrayI8)output);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImageNormalized.horizontal((Kernel1D_S32)kernel, (GrayS16)input, (GrayI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedF32) {
                    ConvolveImageNormalized.horizontal((Kernel1D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output);
                    break;
                }
                if (input instanceof InterleavedF64) {
                    ConvolveImageNormalized.horizontal((Kernel1D_F64)kernel, (InterleavedF64)input, (InterleavedF64)output);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    ConvolveImageNormalized.horizontal((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedI8)output);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImageNormalized.horizontal((Kernel1D_S32)kernel, (InterleavedS16)input, (InterleavedI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.horizontalNormalized(kernel, inp.getBand(i), outp.getBand(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image family");
            }
        }
    }

    public static <T extends ImageBase<T>, K extends Kernel1D> void verticalNormalized(K kernel, T input, T output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImageNormalized.vertical((Kernel1D_F32)kernel, (GrayF32)input, (GrayF32)output);
                    break;
                }
                if (input instanceof GrayF64) {
                    ConvolveImageNormalized.vertical((Kernel1D_F64)kernel, (GrayF64)input, (GrayF64)output);
                    break;
                }
                if (input instanceof GrayU8) {
                    ConvolveImageNormalized.vertical((Kernel1D_S32)kernel, (GrayU8)input, (GrayI8)output);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImageNormalized.vertical((Kernel1D_S32)kernel, (GrayS16)input, (GrayI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedF32) {
                    ConvolveImageNormalized.vertical((Kernel1D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output);
                    break;
                }
                if (input instanceof InterleavedF64) {
                    ConvolveImageNormalized.vertical((Kernel1D_F64)kernel, (InterleavedF64)input, (InterleavedF64)output);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    ConvolveImageNormalized.vertical((Kernel1D_S32)kernel, (InterleavedU8)input, (InterleavedI8)output);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImageNormalized.vertical((Kernel1D_S32)kernel, (InterleavedS16)input, (InterleavedI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.verticalNormalized(kernel, inp.getBand(i), outp.getBand(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image family");
            }
        }
    }

    public static <T extends ImageBase<T>, K extends Kernel2D> void convolveNormalized(K kernel, T input, T output) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayF32) {
                    ConvolveImageNormalized.convolve((Kernel2D_F32)kernel, (GrayF32)input, (GrayF32)output);
                    break;
                }
                if (input instanceof GrayF64) {
                    ConvolveImageNormalized.convolve((Kernel2D_F64)kernel, (GrayF64)input, (GrayF64)output);
                    break;
                }
                if (input instanceof GrayU8) {
                    ConvolveImageNormalized.convolve((Kernel2D_S32)kernel, (GrayU8)input, (GrayI8)output);
                    break;
                }
                if (input instanceof GrayS16) {
                    ConvolveImageNormalized.convolve((Kernel2D_S32)kernel, (GrayS16)input, (GrayI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedF32) {
                    ConvolveImageNormalized.convolve((Kernel2D_F32)kernel, (InterleavedF32)input, (InterleavedF32)output);
                    break;
                }
                if (input instanceof InterleavedF64) {
                    ConvolveImageNormalized.convolve((Kernel2D_F64)kernel, (InterleavedF64)input, (InterleavedF64)output);
                    break;
                }
                if (input instanceof InterleavedU8) {
                    ConvolveImageNormalized.convolve((Kernel2D_S32)kernel, (InterleavedU8)input, (InterleavedI8)output);
                    break;
                }
                if (input instanceof InterleavedS16) {
                    ConvolveImageNormalized.convolve((Kernel2D_S32)kernel, (InterleavedS16)input, (InterleavedI16)output);
                    break;
                }
                throw new IllegalArgumentException("Unknown image type: " + input.getClass().getName());
            }
            case PLANAR: {
                Planar inp = (Planar)input;
                Planar outp = (Planar)output;
                for (int i = 0; i < inp.getNumBands(); ++i) {
                    GConvolveImageOps.convolveNormalized(kernel, inp.getBand(i), outp.getBand(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image family");
            }
        }
    }
}

