/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.misc.CodeGeneratorUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public abstract class CodeGeneratorBase {
    protected PrintStream out;
    protected String className;

    public CodeGeneratorBase(boolean useDefaultName) {
        if (useDefaultName) {
            this.autoSelectName();
        }
    }

    public CodeGeneratorBase() {
        this.autoSelectName();
    }

    public void autoSelectName() {
        this.className = this.getClass().getSimpleName();
        if (this.className.startsWith("Generate")) {
            int l = new String("Generate").length();
            this.className = this.className.substring(l, this.className.length());
            try {
                this.initFile();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            System.out.println("Class name doesn't start with Generate");
        }
    }

    public abstract void generate() throws FileNotFoundException;

    public void initFile() throws FileNotFoundException {
        this.out = new PrintStream(new FileOutputStream(this.className + ".java"));
        this.out.print(CodeGeneratorUtil.copyright);
        this.out.println();
        this.out.println("package " + this.getPackage() + ";");
        this.out.println();
    }

    public void setOutputFile(String className) throws FileNotFoundException {
        if (this.className != null) {
            throw new IllegalArgumentException("ClassName already set.  Out of date code?");
        }
        this.className = className;
        this.initFile();
    }

    public String generatedString() {
        return "@Generated(\"" + this.getClass().getName() + "\")\n";
    }

    public String getPackage() {
        return this.getClass().getPackage().getName();
    }
}

