/*
 * Copyright (c) 2011-2018, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.core.image.impl;

import boofcv.struct.image.*;

/**
 * Low level implementations of different methods for converting {@link boofcv.struct.image.ImageInterleaved} into
 * {@link boofcv.struct.image.ImageGray}.
 *
 * <ul>
 * <li>Average computes the average value of each pixel across the bands.
 * </ul>
 *
 * <p>
 * DO NOT MODIFY: This class was automatically generated by boofcv.core.image.impl.GenerateConvertInterleavedToSingle
 * </p>
 *
 * @author Peter Abeles
 */
public class ConvertInterleavedToSingle {

	public static void average( InterleavedU8 from , GrayU8 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++]& 0xFF;
					sum += from.data[indexFrom++]& 0xFF;
					to.data[indexTo++] = (byte)(sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++]& 0xFF;
					sum += from.data[indexFrom++]& 0xFF;
					sum += from.data[indexFrom++]& 0xFF;
					to.data[indexTo++] = (byte)(sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					int sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++]& 0xFF;
					}
					to.data[indexTo++] = (byte)(sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedS8 from , GrayS8 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (byte)(sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (byte)(sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					int sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++];
					}
					to.data[indexTo++] = (byte)(sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedU16 from , GrayU16 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++]& 0xFFFF;
					sum += from.data[indexFrom++]& 0xFFFF;
					to.data[indexTo++] = (short)(sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++]& 0xFFFF;
					sum += from.data[indexFrom++]& 0xFFFF;
					sum += from.data[indexFrom++]& 0xFFFF;
					to.data[indexTo++] = (short)(sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					int sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++]& 0xFFFF;
					}
					to.data[indexTo++] = (short)(sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedS16 from , GrayS16 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (short)(sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (short)(sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					int sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++];
					}
					to.data[indexTo++] = (short)(sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedS32 from , GrayS32 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					int sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					int sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedS64 from , GrayS64 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					long sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					long sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					long sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedF32 from , GrayF32 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					float sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					float sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					float sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
		}
	}

	public static void average( InterleavedF64 from , GrayF64 to ) {
		final int numBands = from.getNumBands();

		if( numBands == 1 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				System.arraycopy(from.data,indexFrom,to.data,indexTo,from.width);
			}
		} else if( numBands == 2 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;
				
				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					double sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/2);
				}
			}
		} else if( numBands == 3 ) {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);
				int indexEndTo = indexTo + from.width;

				while( indexTo < indexEndTo ) {
//				for (int x = 0; x < from.width; x++ ) {
					double sum = from.data[indexFrom++];
					sum += from.data[indexFrom++];
					sum += from.data[indexFrom++];
					to.data[indexTo++] = (sum/3);
				}
			}
		} else {
			for (int y = 0; y < from.height; y++) {
				int indexFrom = from.getIndex(0, y);
				int indexTo = to.getIndex(0, y);

				for (int x = 0; x < from.width; x++ ) {
					double sum = 0;
					int indexFromEnd = indexFrom + numBands;
					while( indexFrom < indexFromEnd ) {
						sum += from.data[indexFrom++];
					}
					to.data[indexTo++] = (sum/numBands);
				}
			}
		}
	}


}
