/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public abstract class ImageDistortBasic_SB<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
extends ImageDistortBasic<Input, Output, InterpolatePixelS<Input>> {
    public ImageDistortBasic_SB(InterpolatePixelS<Input> interp) {
        super(interp);
    }

    @Override
    public void applyAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY));
                ++x;
                ++indexDst;
            }
        }
    }

    @Override
    public void applyAll(GrayU8 mask) {
        float maxWidth = ((ImageGray)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageGray)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY));
                mask.data[indexMsk] = this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX <= maxWidth && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY <= maxHeight ? (byte)1 : 0;
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    @Override
    public void applyOnlyInside() {
        float maxWidth = ((ImageGray)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageGray)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX <= maxWidth && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY <= maxHeight) {
                    this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    @Override
    public void applyOnlyInside(GrayU8 mask) {
        float maxWidth = ((ImageGray)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageGray)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX <= maxWidth && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY <= maxHeight) {
                    this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.dstToSrc.distX, this.dstToSrc.distY));
                    mask.data[indexMsk] = 1;
                } else {
                    mask.data[indexMsk] = 0;
                }
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    protected abstract void assign(int var1, float var2);
}

