/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;

public abstract class ImageDistortCache_SB<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageDistort<Input, Output> {
    private int width = -1;
    private int height = -1;
    private Point2D_F32[] map;
    private InterpolatePixelS<Input> interp;
    private PixelTransform2_F32 dstToSrc;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    protected boolean renderAll = true;
    protected Input srcImg;
    protected Output dstImg;
    protected boolean dirty;

    public ImageDistortCache_SB(InterpolatePixelS<Input> interp) {
        this.interp = interp;
    }

    @Override
    public void setModel(PixelTransform2_F32 dstToSrc) {
        this.dirty = true;
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(Input srcImg, Output dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageGray)dstImg).width;
        this.y1 = ((ImageGray)dstImg).height;
        if (this.renderAll) {
            this.renderAll();
        } else {
            this.applyOnlyInside();
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, GrayU8 mask) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageGray)dstImg).width;
        this.y1 = ((ImageGray)dstImg).height;
        if (this.renderAll) {
            this.renderAll(mask);
        } else {
            this.applyOnlyInside(mask);
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.renderAll) {
            this.renderAll();
        } else {
            this.applyOnlyInside();
        }
    }

    private void init(Input srcImg, Output dstImg) {
        if (this.dirty || this.width != ((ImageGray)dstImg).width || this.height != ((ImageGray)dstImg).height) {
            this.width = ((ImageGray)dstImg).width;
            this.height = ((ImageGray)dstImg).height;
            this.map = new Point2D_F32[this.width * this.height];
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = new Point2D_F32();
            }
            int index = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.dstToSrc.compute(x, y);
                    this.map[index++].set(this.dstToSrc.distX, this.dstToSrc.distY);
                }
            }
            this.dirty = false;
        } else if (((ImageGray)dstImg).width != this.width || ((ImageGray)dstImg).height != this.height) {
            throw new IllegalArgumentException("Unexpected dstImg dimension");
        }
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
    }

    public void renderAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                this.assign(indexDst, this.interp.get(s.x, s.y));
                ++x;
                ++indexDst;
            }
        }
    }

    public void renderAll(GrayU8 mask) {
        float maxWidth = ((ImageBase)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                this.assign(indexDst, this.interp.get(s.x, s.y));
                mask.data[indexMsk] = s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight ? (byte)1 : 0;
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    public void applyOnlyInside() {
        float maxWidth = ((ImageBase)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                if (s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight) {
                    this.assign(indexDst, this.interp.get(s.x, s.y));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    public void applyOnlyInside(GrayU8 mask) {
        float maxWidth = ((ImageBase)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageBase)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                Point2D_F32 s = this.map[indexDst];
                if (s.x >= 0.0f && s.x <= maxWidth && s.y >= 0.0f && s.y <= maxHeight) {
                    this.assign(indexDst, this.interp.get(s.x, s.y));
                    mask.data[indexMsk] = 1;
                } else {
                    mask.data[indexMsk] = 0;
                }
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    protected abstract void assign(int var1, float var2);

    public Point2D_F32[] getMap() {
        return this.map;
    }

    public InterpolatePixelS<Input> getInterp() {
        return this.interp;
    }

    public PixelTransform2_F32 getDstToSrc() {
        return this.dstToSrc;
    }

    @Override
    public void setRenderAll(boolean renderAll) {
        this.renderAll = renderAll;
    }

    @Override
    public boolean getRenderAll() {
        return this.renderAll;
    }

    @Override
    public PixelTransform2_F32 getModel() {
        return this.dstToSrc;
    }
}

