/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import georegression.struct.point.Point2D_F32;
import org.ejml.UtilEjml;

public class PixelTransformCached_F32
extends PixelTransform2_F32 {
    Point2D_F32[] map;
    int width;
    int height;
    boolean ignoreNaN = true;

    public PixelTransformCached_F32(int width, int height, Point2Transform2_F32 transform) {
        this(width, height, new PointToPixelTransform_F32(transform));
    }

    public PixelTransformCached_F32(int width, int height, PixelTransform2_F32 transform) {
        this.width = width + 1;
        this.height = height + 1;
        this.map = new Point2D_F32[this.width * this.height];
        int index = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                transform.compute(x, y);
                this.map[index++] = !this.ignoreNaN && (UtilEjml.isUncountable((float)transform.distX) || UtilEjml.isUncountable((float)transform.distY)) ? new Point2D_F32(-1.0f, -1.0f) : new Point2D_F32(transform.distX, transform.distY);
            }
        }
    }

    public Point2D_F32 getPixel(int x, int y) {
        return this.map[this.width * y + x];
    }

    public boolean isIgnoreNaN() {
        return this.ignoreNaN;
    }

    public void setIgnoreNaN(boolean ignoreNaN) {
        this.ignoreNaN = ignoreNaN;
    }

    @Override
    public void compute(int x, int y) {
        Point2D_F32 p = this.map[y * this.width + x];
        this.distX = p.x;
        this.distY = p.y;
    }
}

