/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class LaplacianEdge {
    public static Kernel2D_S32 kernel_I32 = new Kernel2D_S32(3, new int[]{0, 1, 0, 1, -4, 1, 0, 1, 0});
    public static Kernel2D_F32 kernel_F32 = new Kernel2D_F32(3, new float[]{0.0f, 1.0f, 0.0f, 1.0f, -4.0f, 1.0f, 0.0f, 1.0f, 0.0f});

    public static void process(GrayU8 orig, GrayS16 deriv) {
        deriv.reshape(orig.width, orig.height);
        byte[] data = orig.data;
        short[] out = deriv.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int index;
            int indexOut = deriv.startIndex + deriv.stride * y + 1;
            int endX = index + width - 2;
            for (index = orig.startIndex + stride * y + 1; index < endX; ++index) {
                int v = data[index - stride] & 0xFF;
                v += data[index - 1] & 0xFF;
                v += -4 * (data[index] & 0xFF);
                v += data[index + 1] & 0xFF;
                out[indexOut++] = (short)(v += data[index + stride] & 0xFF);
            }
        }
    }

    public static void process(GrayU8 orig, GrayF32 deriv) {
        deriv.reshape(orig.width, orig.height);
        byte[] data = orig.data;
        float[] out = deriv.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int index;
            int indexOut = deriv.startIndex + deriv.stride * y + 1;
            int endX = index + width - 2;
            for (index = orig.startIndex + stride * y + 1; index < endX; ++index) {
                int v = data[index - stride] & 0xFF;
                v += data[index - 1] & 0xFF;
                v += -4 * (data[index] & 0xFF);
                v += data[index + 1] & 0xFF;
                out[indexOut++] = v += data[index + stride] & 0xFF;
            }
        }
    }

    public static void process(GrayF32 orig, GrayF32 deriv) {
        deriv.reshape(orig.width, orig.height);
        float[] data = orig.data;
        float[] out = deriv.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int index;
            int indexOut = deriv.startIndex + deriv.stride * y + 1;
            int endX = index + width - 2;
            for (index = orig.startIndex + stride * y + 1; index < endX; ++index) {
                float v = data[index - stride] + data[index - 1];
                v += data[index + 1];
                out[indexOut++] = (v += data[index + stride]) - 4.0f * data[index];
            }
        }
    }
}

