/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.core.image.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.sparse.GradientValue_F32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseSobel_F32
implements SparseImageGradient<GrayF32, GradientValue_F32> {
    GrayF32 input;
    ImageBorder_F32 border;
    GradientValue_F32 gradient = new GradientValue_F32();

    public GradientSparseSobel_F32(ImageBorder_F32 border) {
        this.border = border;
    }

    @Override
    public GradientValue_F32 compute(int x, int y) {
        float a22;
        float a21;
        float a20;
        float a12;
        float a10;
        float a02;
        float a01;
        float a00;
        if (x >= 1 && y >= 1 && x < this.input.width - 1 && y < this.input.height - 1) {
            int s = this.input.stride;
            int tl = this.input.startIndex + this.input.stride * (y - 1) + x - 1;
            a00 = this.input.data[tl];
            a01 = this.input.data[tl + 1];
            a02 = this.input.data[tl + 2];
            a10 = this.input.data[tl + s];
            a12 = this.input.data[tl + 2 + s];
            a20 = this.input.data[tl + 2 * s];
            a21 = this.input.data[tl + 1 + 2 * s];
            a22 = this.input.data[tl + 2 + 2 * s];
        } else {
            a00 = this.border.get(x - 1, y - 1);
            a01 = this.border.get(x, y - 1);
            a02 = this.border.get(x + 1, y - 1);
            a10 = this.border.get(x - 1, y);
            a12 = this.border.get(x + 1, y);
            a20 = this.border.get(x - 1, y + 1);
            a21 = this.border.get(x, y + 1);
            a22 = this.border.get(x + 1, y + 1);
        }
        this.gradient.y = -(a00 + 2.0f * a01 + a02) * 0.25f;
        this.gradient.y += (a20 + 2.0f * a21 + a22) * 0.25f;
        this.gradient.x = -(a00 + 2.0f * a10 + a20) * 0.25f;
        this.gradient.x += (a02 + 2.0f * a12 + a22) * 0.25f;
        return this.gradient;
    }

    @Override
    public Class<GradientValue_F32> getGradientType() {
        return GradientValue_F32.class;
    }

    @Override
    public void setImage(GrayF32 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage(input);
        }
    }

    @Override
    public boolean isInBounds(int x, int y) {
        return this.border != null || x >= 1 && y >= 1 && x < this.input.width - 1 && y < this.input.height - 1;
    }
}

