/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixelS;
import boofcv.core.image.border.ImageBorder_S32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public class ImplBilinearPixel_U8
extends BilinearPixelS<GrayU8> {
    public ImplBilinearPixel_U8() {
    }

    public ImplBilinearPixel_U8(GrayU8 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((GrayU8)this.orig).startIndex + yt * this.stride + xt;
        byte[] data = ((GrayU8)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * (float)(data[index] & 0xFF);
        val += ax * (1.0f - ay) * (float)(data[index + 1] & 0xFF);
        val += ax * ay * (float)(data[index + 1 + this.stride] & 0xFF);
        return val += (1.0f - ax) * ay * (float)(data[index + this.stride] & 0xFF);
    }

    public float get_border(float x, float y) {
        float xf = (float)Math.floor(x);
        float yf = (float)Math.floor(y);
        int xt = (int)xf;
        int yt = (int)yf;
        float ax = x - xf;
        float ay = y - yf;
        ImageBorder_S32 border = (ImageBorder_S32)this.border;
        float val = (1.0f - ax) * (1.0f - ay) * (float)border.get(xt, yt);
        val += ax * (1.0f - ay) * (float)border.get(xt + 1, yt);
        val += ax * ay * (float)border.get(xt + 1, yt + 1);
        return val += (1.0f - ax) * ay * (float)border.get(xt, yt + 1);
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 2) || y > (float)(this.height - 2)) {
            return this.get_border(x, y);
        }
        return this.get_fast(x, y);
    }

    @Override
    public ImageType<GrayU8> getImageType() {
        return ImageType.single(GrayU8.class);
    }
}

