/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

public class HistogramStatistics {
    public static double variance(int[] histogram, double mean, int N) {
        return HistogramStatistics.variance(histogram, mean, HistogramStatistics.count(histogram, N), N);
    }

    public static double variance(int[] histogram, double mean, int counts, int N) {
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            double d = (double)i - mean;
            sum += d * d * (double)histogram[i];
        }
        return sum / (double)counts;
    }

    public static int count(int[] histogram, int N) {
        int counts = 0;
        for (int i = 0; i < N; ++i) {
            counts += histogram[i];
        }
        return counts;
    }

    public static double mean(int[] histogram, int N) {
        return HistogramStatistics.mean(histogram, HistogramStatistics.count(histogram, N), N);
    }

    public static double mean(int[] histogram, int counts, int N) {
        double sum = 0.0;
        for (int i = 0; i < N; ++i) {
            sum += (double)(histogram[i] * i);
        }
        return sum / (double)counts;
    }

    public static int percentile(int[] histogram, double fraction, int N) {
        return HistogramStatistics.percentile(histogram, HistogramStatistics.count(histogram, N), fraction, N);
    }

    public static int percentile(int[] histogram, int counts, double fraction, int N) {
        int i;
        int count = 0;
        int target = (int)((double)counts * fraction + 0.5);
        if (count >= target) {
            return 0;
        }
        for (i = 0; i < N && (count += histogram[i]) < target; ++i) {
        }
        return i;
    }
}

