/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel2D;

public class Kernel2D_F32
extends Kernel2D {
    public float[] data;

    public Kernel2D_F32(int width, float[] data) {
        super(width);
        this.data = new float[width * width];
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }

    public Kernel2D_F32(int width) {
        super(width);
        this.data = new float[width * width];
    }

    public Kernel2D_F32(int width, int offset) {
        super(width, offset);
        this.data = new float[width * width];
    }

    protected Kernel2D_F32() {
    }

    public static Kernel2D_F32 wrap(float[] data, int width, int offset) {
        if (width % 2 == 0 && width <= 0 && width * width > data.length) {
            throw new IllegalArgumentException("invalid width");
        }
        Kernel2D_F32 ret = new Kernel2D_F32();
        ret.data = data;
        ret.width = width;
        ret.offset = offset;
        return ret;
    }

    public float get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public void set(int x, int y, float value) {
        this.data[y * this.width + x] = value;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    public float[] getData() {
        return this.data;
    }

    public float computeSum() {
        int N = this.width * this.width;
        float total = 0.0f;
        for (int i = 0; i < N; ++i) {
            total += this.data[i];
        }
        return total;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                System.out.printf("%15f ", Float.valueOf(this.data[i * this.width + j]));
            }
            System.out.println();
        }
        System.out.println();
    }

    public Kernel2D_F32 copy() {
        Kernel2D_F32 ret = new Kernel2D_F32(this.width);
        ret.offset = this.offset;
        System.arraycopy(this.data, 0, ret.data, 0, this.data.length);
        return ret;
    }

    @Override
    public double getDouble(int x, int y) {
        return this.get(x, y);
    }
}

