/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedInteger;

public abstract class InterleavedI16<T extends InterleavedI16<T>>
extends InterleavedInteger<T> {
    public short[] data;

    public InterleavedI16(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedI16() {
    }

    @Override
    public String toString_element(int index) {
        return String.format("%04x", this.data[index] & 0xFFFF);
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.I16;
    }

    public short[] get(int x, int y, short[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new short[this.numBands];
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
        return storage;
    }

    public void set(int x, int y, short ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public void setBand(int x, int y, int band, short value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    public void unsafe_set(int x, int y, int ... value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = (short)value[i];
            ++i;
            ++index;
        }
    }

    @Override
    public void setBand(int x, int y, int band, int value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = (short)value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Short.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (short[])data;
    }
}

