/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageInterleaved;

public class InterleavedS64
extends ImageInterleaved<InterleavedS64> {
    public long[] data;

    public InterleavedS64(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedS64() {
    }

    @Override
    public String toString_element(int index) {
        return String.format("%016x", this.data[index]);
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S64;
    }

    public long[] get(int x, int y, long[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new long[this.numBands];
        }
        this.unsafe_get(x, y, storage);
        return storage;
    }

    public void unsafe_get(int x, int y, long[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
    }

    public void set(int x, int y, long ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        this.unsafe_set(x, y, value);
    }

    public void unsafe_set(int x, int y, long ... value) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public long getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    public void setBand(int x, int y, int band, long value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getPrimitiveDataType() {
        return Long.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (long[])data;
    }

    @Override
    public InterleavedS64 createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedS64();
        }
        return new InterleavedS64(imgWidth, imgHeight, this.numBands);
    }
}

