/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class FilterSequence<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements FilterImageInterface<Input, Output> {
    FilterImageInterface<Input, Output> firstFilter;
    FilterImageInterface<Output, Output>[] sequence;
    int borderHorizontal = 0;
    int borderVertical = 0;

    public FilterSequence(FilterImageInterface<Input, Output> first, FilterImageInterface<Output, Output> ... sequence) {
        this.firstFilter = first;
        this.sequence = sequence;
        if (first.getHorizontalBorder() > this.borderHorizontal) {
            this.borderHorizontal = first.getHorizontalBorder();
        }
        if (first.getVerticalBorder() > this.borderVertical) {
            this.borderVertical = first.getVerticalBorder();
        }
        for (FilterImageInterface<Output, Output> f : sequence) {
            if (f.getHorizontalBorder() > this.borderHorizontal) {
                this.borderHorizontal = f.getHorizontalBorder();
            }
            if (f.getVerticalBorder() <= this.borderVertical) continue;
            this.borderVertical = f.getVerticalBorder();
        }
    }

    @Override
    public void process(Input input, Output output) {
        ImageGray temp1 = (ImageGray)output.createNew(((ImageGray)output).width, ((ImageGray)output).height);
        ImageGray temp2 = (ImageGray)output.createNew(((ImageGray)output).width, ((ImageGray)output).height);
        this.firstFilter.process(input, temp1);
        for (FilterImageInterface<ImageGray, ImageGray> filterImageInterface : this.sequence) {
            filterImageInterface.process(temp1, temp2);
            ImageGray swap = temp1;
            temp1 = temp2;
            temp2 = swap;
            GImageMiscOps.fill((ImageBase)temp2, 0.0);
        }
        output.setTo(temp1);
    }

    @Override
    public int getHorizontalBorder() {
        return this.borderHorizontal;
    }

    @Override
    public int getVerticalBorder() {
        return this.borderVertical;
    }

    @Override
    public ImageType<Input> getInputType() {
        return this.firstFilter.getInputType();
    }

    @Override
    public ImageType<Output> getOutputType() {
        return this.firstFilter.getOutputType();
    }
}

