/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.BoofDefaults;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ImageGradient_Reflection<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageGradient<Input, Output> {
    BorderType borderType = BoofDefaults.DERIV_BORDER_TYPE;
    ImageBorder<Input> border;
    private Method m;

    public ImageGradient_Reflection(Method m) {
        this.m = m;
        this.setBorderType(this.borderType);
    }

    @Override
    public void process(Input inputImage, Output derivX, Output derivY) {
        try {
            this.m.invoke(null, inputImage, derivX, derivY, this.border);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setBorderType(BorderType type) {
        this.borderType = type;
        Class<?> imageType = this.m.getParameterTypes()[0];
        this.border = FactoryImageBorder.single(imageType, this.borderType);
    }

    @Override
    public BorderType getBorderType() {
        return this.borderType;
    }

    @Override
    public int getBorder() {
        if (this.borderType != BorderType.SKIP) {
            return 0;
        }
        return 1;
    }

    @Override
    public ImageType<Output> getDerivativeType() {
        return ImageType.single(this.m.getParameterTypes()[1]);
    }
}

