/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistortBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F32;

public abstract class ImageDistortBasic_SB<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
extends ImageDistortBasic<Input, Output, InterpolatePixelS<Input>> {
    Point2D_F32 distorted = new Point2D_F32();

    public ImageDistortBasic_SB(InterpolatePixelS<Input> interp) {
        super(interp);
    }

    @Override
    public void applyAll() {
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.distorted.x, this.distorted.y));
                ++x;
                ++indexDst;
            }
        }
    }

    @Override
    public void applyAll(GrayU8 mask) {
        float maxWidth = ((ImageGray)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageGray)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.distorted.x, this.distorted.y));
                mask.data[indexMsk] = this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight ? (byte)1 : 0;
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    @Override
    public void applyOnlyInside() {
        float maxWidth = ((ImageGray)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageGray)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                    this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.distorted.x, this.distorted.y));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    @Override
    public void applyOnlyInside(GrayU8 mask) {
        float maxWidth = ((ImageGray)this.srcImg).getWidth() - 1;
        float maxHeight = ((ImageGray)this.srcImg).getHeight() - 1;
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageGray)this.dstImg).startIndex + ((ImageGray)this.dstImg).stride * y + this.x0;
            int indexMsk = mask.startIndex + mask.stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y, (Object)this.distorted);
                if (this.distorted.x >= 0.0f && this.distorted.x <= maxWidth && this.distorted.y >= 0.0f && this.distorted.y <= maxHeight) {
                    this.assign(indexDst, ((InterpolatePixelS)this.interp).get(this.distorted.x, this.distorted.y));
                    mask.data[indexMsk] = 1;
                } else {
                    mask.data[indexMsk] = 0;
                }
                ++x;
                ++indexDst;
                ++indexMsk;
            }
        }
    }

    protected abstract void assign(int var1, float var2);
}

