/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import boofcv.struct.ConnectRule;
import boofcv.struct.PackedSetsPoint2D_I32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;

public class ContourTracer {
    private int maxContourSize = Integer.MAX_VALUE;
    private final ConnectRule rule;
    private final int ruleN;
    private PackedSetsPoint2D_I32 storagePoints;
    private GrayU8 binary;
    private GrayS32 labeled;
    private int x;
    private int y;
    private int label;
    private int dir;
    private int indexBinary;
    private int indexLabel;
    private int[] offsetsBinary;
    private int[] offsetsLabeled;
    private int[] nextDirection;

    public ContourTracer(ConnectRule rule) {
        this.rule = rule;
        if (ConnectRule.EIGHT == rule) {
            this.nextDirection = new int[8];
            for (int i = 0; i < 8; ++i) {
                this.nextDirection[i] = ((i + 4) % 8 + 2) % 8;
            }
            this.ruleN = 8;
        } else if (ConnectRule.FOUR == rule) {
            this.nextDirection = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.nextDirection[i] = ((i + 2) % 4 + 1) % 4;
            }
            this.ruleN = 4;
        } else {
            throw new IllegalArgumentException("Connectivity rule must be 4 or 8 not " + rule);
        }
        this.offsetsBinary = new int[this.ruleN];
        this.offsetsLabeled = new int[this.ruleN];
    }

    public void setInputs(GrayU8 binary, GrayS32 labeled, PackedSetsPoint2D_I32 storagePoints) {
        this.binary = binary;
        this.labeled = labeled;
        this.storagePoints = storagePoints;
        if (this.rule == ConnectRule.EIGHT) {
            this.setOffsets8(this.offsetsBinary, binary.stride);
            this.setOffsets8(this.offsetsLabeled, labeled.stride);
        } else {
            this.setOffsets4(this.offsetsBinary, binary.stride);
            this.setOffsets4(this.offsetsLabeled, labeled.stride);
        }
    }

    private void setOffsets8(int[] offsets, int stride) {
        int s = stride;
        offsets[0] = 1;
        offsets[1] = 1 + s;
        offsets[2] = s;
        offsets[3] = -1 + s;
        offsets[4] = -1;
        offsets[5] = -1 - s;
        offsets[6] = -s;
        offsets[7] = 1 - s;
    }

    private void setOffsets4(int[] offsets, int stride) {
        int s = stride;
        offsets[0] = 1;
        offsets[1] = s;
        offsets[2] = -1;
        offsets[3] = -s;
    }

    public void trace(int label, int initialX, int initialY, boolean external) {
        int initialDir = this.rule == ConnectRule.EIGHT ? (external ? 7 : 3) : (external ? 0 : 2);
        this.label = label;
        this.dir = initialDir;
        this.x = initialX;
        this.y = initialY;
        this.indexBinary = this.binary.getIndex(this.x, this.y);
        this.indexLabel = this.labeled.getIndex(this.x - 1, this.y - 1);
        this.add(this.x, this.y);
        if (!this.searchOne()) {
            return;
        }
        initialDir = this.dir;
        this.moveToNext();
        this.dir = this.nextDirection[this.dir];
        while (true) {
            this.searchOne();
            if (this.x == initialX && this.y == initialY && this.dir == initialDir) {
                return;
            }
            this.add(this.x, this.y);
            this.moveToNext();
            this.dir = this.nextDirection[this.dir];
        }
    }

    private boolean searchOne() {
        if (this.ruleN == 4) {
            return this.searchOne4();
        }
        return this.searchOne8();
    }

    private boolean searchOne4() {
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 4;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 4;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 4;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 4;
        return false;
    }

    private boolean searchOne8() {
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        if (this.checkOne(this.indexBinary + this.offsetsBinary[this.dir])) {
            return true;
        }
        this.dir = (this.dir + 1) % 8;
        return false;
    }

    private boolean checkOne(int index) {
        if (this.binary.data[index] == 1) {
            return true;
        }
        this.binary.data[index] = -1;
        return false;
    }

    private void moveToNext() {
        this.indexBinary += this.offsetsBinary[this.dir];
        this.indexLabel += this.offsetsLabeled[this.dir];
        int a = this.indexBinary - this.binary.startIndex;
        this.x = a % this.binary.stride;
        this.y = a / this.binary.stride;
    }

    private void add(int x, int y) {
        this.labeled.data[this.indexLabel] = this.label;
        if (this.storagePoints.sizeOfTail() < this.maxContourSize) {
            this.storagePoints.addPointToTail(x - 1, y - 1);
        }
    }

    public void setMaxContourSize(int maxContourSize) {
        this.maxContourSize = maxContourSize;
    }

    public ConnectRule getConnectRule() {
        return this.rule;
    }
}

