/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur;

import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.concurrency.DWorkArrays;
import boofcv.concurrency.FWorkArrays;
import boofcv.concurrency.IWorkArrays;
import boofcv.concurrency.WorkArrays;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import javax.annotation.Nullable;

public class GBlurImageOps {
    public static <T extends ImageBase<T>> T mean(T input, @Nullable T output, int radius, @Nullable ImageBase storage, @Nullable WorkArrays workVert) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.mean((GrayU8)input, (GrayU8)output, radius, (GrayU8)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayU16) {
            return (T)BlurImageOps.mean((GrayU16)input, (GrayU16)output, radius, (GrayU16)storage, (IWorkArrays)workVert);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.mean((GrayF32)input, (GrayF32)output, radius, (GrayF32)storage, (FWorkArrays)workVert);
        }
        if (input instanceof GrayF64) {
            return (T)BlurImageOps.mean((GrayF64)input, (GrayF64)output, radius, (GrayF64)storage, (DWorkArrays)workVert);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.mean((Planar)input, (Planar)output, radius, (ImageGray)storage, workVert);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase<T>> T median(T input, @Nullable T output, int radius, @Nullable WorkArrays work) {
        if (input instanceof GrayU8) {
            return (T)BlurImageOps.median((GrayU8)input, (GrayU8)output, radius, (IWorkArrays)work);
        }
        if (input instanceof GrayF32) {
            return (T)BlurImageOps.median((GrayF32)input, (GrayF32)output, radius);
        }
        if (input instanceof Planar) {
            return (T)BlurImageOps.median((Planar)input, (Planar)output, radius, work);
        }
        throw new IllegalArgumentException("Unsupported image type");
    }

    public static <T extends ImageBase<T>> T gaussian(T input, @Nullable T output, double sigma, int radius, @Nullable ImageBase storage) {
        switch (input.getImageType().getFamily()) {
            case GRAY: {
                if (input instanceof GrayU8) {
                    return (T)BlurImageOps.gaussian((GrayU8)input, (GrayU8)output, sigma, radius, (GrayU8)storage);
                }
                if (input instanceof GrayU16) {
                    return (T)BlurImageOps.gaussian((GrayU16)input, (GrayU16)output, sigma, radius, (GrayU16)storage);
                }
                if (input instanceof GrayF32) {
                    return (T)BlurImageOps.gaussian((GrayF32)input, (GrayF32)output, sigma, radius, (GrayF32)storage);
                }
                if (input instanceof GrayF64) {
                    return (T)BlurImageOps.gaussian((GrayF64)input, (GrayF64)output, sigma, radius, (GrayF64)storage);
                }
                throw new IllegalArgumentException("Unsupported image type: " + input.getClass().getSimpleName());
            }
            case INTERLEAVED: {
                if (input instanceof InterleavedU8) {
                    return (T)BlurImageOps.gaussian((InterleavedU8)input, (InterleavedU8)output, sigma, radius, (InterleavedU8)storage);
                }
                if (input instanceof InterleavedU16) {
                    return (T)BlurImageOps.gaussian((InterleavedU16)input, (InterleavedU16)output, sigma, radius, (InterleavedU16)storage);
                }
                if (input instanceof InterleavedF32) {
                    return (T)BlurImageOps.gaussian((InterleavedF32)input, (InterleavedF32)output, sigma, radius, (InterleavedF32)storage);
                }
                if (input instanceof InterleavedF64) {
                    return (T)BlurImageOps.gaussian((InterleavedF64)input, (InterleavedF64)output, sigma, radius, (InterleavedF64)storage);
                }
                throw new IllegalArgumentException("Unsupported image type: " + input.getClass().getSimpleName());
            }
            case PLANAR: {
                return (T)BlurImageOps.gaussian((Planar)input, (Planar)output, sigma, radius, (ImageGray)storage);
            }
        }
        throw new IllegalArgumentException("Unknown image family");
    }
}

