/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General_SB;
import boofcv.alg.filter.derivative.impl.GradientPrewitt_Shared;
import boofcv.alg.filter.derivative.impl.GradientPrewitt_Shared_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import javax.annotation.Nullable;

public class GradientPrewitt {
    public static Kernel2D_S32 kernelDerivX_I32 = new Kernel2D_S32(3, new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1});
    public static Kernel2D_S32 kernelDerivY_I32 = new Kernel2D_S32(3, new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1});
    public static Kernel2D_F32 kernelDerivX_F32 = new Kernel2D_F32(3, new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f});
    public static Kernel2D_F32 kernelDerivY_F32 = new Kernel2D_F32(3, new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});

    public static Kernel2D getKernelX(boolean isInteger) {
        if (isInteger) {
            return kernelDerivX_I32;
        }
        return kernelDerivX_F32;
    }

    public static void process(GrayU8 orig, GrayS16 derivX, GrayS16 derivY, @Nullable ImageBorder_S32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientPrewitt_Shared_MT.process(orig, derivX, derivY);
        } else {
            GradientPrewitt_Shared.process(orig, derivX, derivY);
        }
        if (border != null) {
            border.setImage((ImageBase)orig);
            ConvolveJustBorder_General_SB.convolve(kernelDerivX_I32, border, (GrayI16)derivX);
            ConvolveJustBorder_General_SB.convolve(kernelDerivY_I32, border, (GrayI16)derivY);
        }
    }

    public static void process(GrayS16 orig, GrayS16 derivX, GrayS16 derivY, @Nullable ImageBorder_S32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientPrewitt_Shared_MT.process(orig, derivX, derivY);
        } else {
            GradientPrewitt_Shared.process(orig, derivX, derivY);
        }
        if (border != null) {
            border.setImage((ImageBase)orig);
            ConvolveJustBorder_General_SB.convolve(kernelDerivX_I32, border, (GrayI16)derivX);
            ConvolveJustBorder_General_SB.convolve(kernelDerivY_I32, border, (GrayI16)derivY);
        }
    }

    public static void process(GrayF32 orig, GrayF32 derivX, GrayF32 derivY, @Nullable ImageBorder_F32 border) {
        InputSanityCheck.reshapeOneIn((ImageBase)orig, (ImageBase)derivX, (ImageBase)derivY);
        if (BoofConcurrency.USE_CONCURRENT) {
            GradientPrewitt_Shared_MT.process(orig, derivX, derivY);
        } else {
            GradientPrewitt_Shared.process(orig, derivX, derivY);
        }
        if (border != null) {
            border.setImage((ImageBase)orig);
            ConvolveJustBorder_General_SB.convolve(kernelDerivX_F32, border, derivX);
            ConvolveJustBorder_General_SB.convolve(kernelDerivY_F32, border, derivY);
        }
    }
}

