/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.NearestNeighborPixelS;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageType;

public class NearestNeighborPixel_S32
extends NearestNeighborPixelS<GrayS32> {
    private int[] data;

    public NearestNeighborPixel_S32() {
    }

    public NearestNeighborPixel_S32(GrayS32 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(GrayS32 image) {
        super.setImage(image);
        this.data = ((GrayS32)this.orig).data;
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((GrayS32)this.orig).startIndex + (int)y * this.stride + (int)x];
    }

    public float get_border(float x, float y) {
        return ((ImageBorder_S32)this.border).get((int)Math.floor(x), (int)Math.floor(y));
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            return this.get_border(x, y);
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((GrayS32)this.orig).startIndex + yy * this.stride + xx];
    }

    @Override
    public InterpolatePixelS<GrayS32> copy() {
        return new NearestNeighborPixel_S32();
    }

    @Override
    public ImageType<GrayS32> getImageType() {
        return ImageType.single(GrayS32.class);
    }
}

