/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.impl.ImplColorRgb;
import boofcv.alg.color.impl.ImplColorRgb_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ColorRgb {
    public static int rgbToGray_Weighted(int r, int g, int b) {
        return (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
    }

    public static float rgbToGray_Weighted(float r, float g, float b) {
        return 0.299f * r + 0.587f * g + 0.114f * b;
    }

    public static double rgbToGray_Weighted(double r, double g, double b) {
        return 0.299 * r + 0.587 * g + 0.114 * b;
    }

    public static void rgbToGray_Weighted(ImageMultiBand rgb, ImageGray gray) {
        gray.reshape(rgb.width, rgb.height);
        switch (rgb.getImageType().getFamily()) {
            case PLANAR: {
                if (gray instanceof GrayU8) {
                    if (BoofConcurrency.USE_CONCURRENT) {
                        ImplColorRgb_MT.rgbToGray_Weighted_U8((Planar<GrayU8>)((Planar)rgb), (GrayU8)gray);
                        break;
                    }
                    ImplColorRgb.rgbToGray_Weighted_U8((Planar<GrayU8>)((Planar)rgb), (GrayU8)gray);
                    break;
                }
                if (gray instanceof GrayF32) {
                    if (BoofConcurrency.USE_CONCURRENT) {
                        ImplColorRgb_MT.rgbToGray_Weighted_F32((Planar<GrayF32>)((Planar)rgb), (GrayF32)gray);
                        break;
                    }
                    ImplColorRgb.rgbToGray_Weighted_F32((Planar<GrayF32>)((Planar)rgb), (GrayF32)gray);
                    break;
                }
                if (gray instanceof GrayF64) {
                    if (BoofConcurrency.USE_CONCURRENT) {
                        ImplColorRgb_MT.rgbToGray_Weighted_F64((Planar<GrayF64>)((Planar)rgb), (GrayF64)gray);
                        break;
                    }
                    ImplColorRgb.rgbToGray_Weighted_F64((Planar<GrayF64>)((Planar)rgb), (GrayF64)gray);
                    break;
                }
                throw new IllegalArgumentException("Unsupported type " + gray.getClass().getSimpleName());
            }
            case INTERLEAVED: {
                if (gray instanceof GrayU8) {
                    if (BoofConcurrency.USE_CONCURRENT) {
                        ImplColorRgb_MT.rgbToGray_Weighted((InterleavedU8)rgb, (GrayU8)gray);
                        break;
                    }
                    ImplColorRgb.rgbToGray_Weighted((InterleavedU8)rgb, (GrayU8)gray);
                    break;
                }
                if (gray instanceof GrayF32) {
                    if (BoofConcurrency.USE_CONCURRENT) {
                        ImplColorRgb_MT.rgbToGray_Weighted((InterleavedF32)rgb, (GrayF32)gray);
                        break;
                    }
                    ImplColorRgb.rgbToGray_Weighted((InterleavedF32)rgb, (GrayF32)gray);
                    break;
                }
                if (gray instanceof GrayF64) {
                    if (BoofConcurrency.USE_CONCURRENT) {
                        ImplColorRgb_MT.rgbToGray_Weighted((InterleavedF64)rgb, (GrayF64)gray);
                        break;
                    }
                    ImplColorRgb.rgbToGray_Weighted((InterleavedF64)rgb, (GrayF64)gray);
                    break;
                }
                throw new IllegalArgumentException("Unsupported type " + gray.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("rgb must be planar or interleaved");
            }
        }
    }
}

