/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ImplColorLab {
    public static void rgbToLab_U8(Planar<GrayU8> rgb, Planar<GrayF32> lab) {
        GrayU8 R = (GrayU8)rgb.getBand(0);
        GrayU8 G = (GrayU8)rgb.getBand(1);
        GrayU8 B = (GrayU8)rgb.getBand(2);
        GrayF32 L_ = (GrayF32)lab.getBand(0);
        GrayF32 A_ = (GrayF32)lab.getBand(1);
        GrayF32 B_ = (GrayF32)lab.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float r = (float)(R.data[indexRgb] & 0xFF) / 255.0f;
                float g = (float)(G.data[indexRgb] & 0xFF) / 255.0f;
                float b = (float)(B.data[indexRgb] & 0xFF) / 255.0f;
                float X = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                float Y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                float Z = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                float xr = X / 0.950456f;
                float yr = Y / 1.0f;
                float zr = Z / 1.088754f;
                float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
                float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
                float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
                L_.data[indexLab] = 116.0f * fy - 16.0f;
                A_.data[indexLab] = 500.0f * (fx - fy);
                B_.data[indexLab] = 200.0f * (fy - fz);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }

    public static void rgbToLab_F32(Planar<GrayF32> rgb, Planar<GrayF32> lab) {
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        GrayF32 L_ = (GrayF32)lab.getBand(0);
        GrayF32 A_ = (GrayF32)lab.getBand(1);
        GrayF32 B_ = (GrayF32)lab.getBand(2);
        for (int row = 0; row < lab.height; ++row) {
            int indexLab = lab.startIndex + row * lab.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < lab.width) {
                float r = R.data[indexRgb] / 255.0f;
                float g = G.data[indexRgb] / 255.0f;
                float b = B.data[indexRgb] / 255.0f;
                float X = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                float Y = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                float Z = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                float xr = X / 0.950456f;
                float yr = Y / 1.0f;
                float zr = Z / 1.088754f;
                float fx = xr > 0.008856f ? (float)Math.pow(xr, 0.3333333432674408) : (903.3f * xr + 16.0f) / 116.0f;
                float fy = yr > 0.008856f ? (float)Math.pow(yr, 0.3333333333333333) : (903.3f * yr + 16.0f) / 116.0f;
                float fz = zr > 0.008856f ? (float)Math.pow(zr, 0.3333333333333333) : (903.3f * zr + 16.0f) / 116.0f;
                L_.data[indexLab] = 116.0f * fy - 16.0f;
                A_.data[indexLab] = 500.0f * (fx - fy);
                B_.data[indexLab] = 200.0f * (fy - fz);
                ++col;
                ++indexLab;
                ++indexRgb;
            }
        }
    }
}

