/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ImplColorXyz {
    public static void rgbToXyz_F32(Planar<GrayF32> rgb, Planar<GrayF32> xyz) {
        InputSanityCheck.checkSameShape(xyz, rgb);
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        GrayF32 X = (GrayF32)xyz.getBand(0);
        GrayF32 Y = (GrayF32)xyz.getBand(1);
        GrayF32 Z = (GrayF32)xyz.getBand(2);
        for (int row = 0; row < xyz.height; ++row) {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float r = R.data[indexRgb] / 255.0f;
                float g = G.data[indexRgb] / 255.0f;
                float b = B.data[indexRgb] / 255.0f;
                X.data[indexXyz] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                Y.data[indexXyz] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                Z.data[indexXyz] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        }
    }

    public static void rgbToXyz_U8(Planar<GrayU8> rgb, Planar<GrayF32> xyz) {
        GrayU8 R = (GrayU8)rgb.getBand(0);
        GrayU8 G = (GrayU8)rgb.getBand(1);
        GrayU8 B = (GrayU8)rgb.getBand(2);
        GrayF32 X = (GrayF32)xyz.getBand(0);
        GrayF32 Y = (GrayF32)xyz.getBand(1);
        GrayF32 Z = (GrayF32)xyz.getBand(2);
        for (int row = 0; row < xyz.height; ++row) {
            int indexXyz = xyz.startIndex + row * xyz.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < xyz.width) {
                float r = (float)(R.data[indexRgb] & 0xFF) / 255.0f;
                float g = (float)(G.data[indexRgb] & 0xFF) / 255.0f;
                float b = (float)(B.data[indexRgb] & 0xFF) / 255.0f;
                X.data[indexXyz] = 0.412453f * r + 0.35758f * g + 0.180423f * b;
                Y.data[indexXyz] = 0.212671f * r + 0.71516f * g + 0.072169f * b;
                Z.data[indexXyz] = 0.019334f * r + 0.119193f * g + 0.950227f * b;
                ++col;
                ++indexXyz;
                ++indexRgb;
            }
        }
    }
}

