/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.border;

import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS32;

public class ConvolveJustBorder_General_SB {
    public static void horizontal(Kernel1D_F32 kernel, ImageBorder_F32 input, GrayF32 output) {
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = output.getWidth();
        int height = output.getHeight();
        int borderRight = kernelWidth - offset - 1;
        for (int y = 0; y < height; ++y) {
            int k;
            float total;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offset; ++x) {
                total = 0.0f;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x + k - offset, y) * dataKer[k];
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - borderRight;
            for (x = width - borderRight; x < width; ++x) {
                total = 0.0f;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x + k - offset, y) * dataKer[k];
                }
                dataDst[indexDest++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageBorder_F32 input, GrayF32 output) {
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = output.getWidth();
        int height = output.getHeight();
        int borderBottom = kernelWidth - offset - 1;
        for (int x = 0; x < width; ++x) {
            int k;
            float total;
            int indexDest = output.startIndex + x;
            int y = 0;
            while (y < offset) {
                total = 0.0f;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x, y + k - offset) * dataKer[k];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - borderBottom) * output.stride + x;
            y = height - borderBottom;
            while (y < height) {
                total = 0.0f;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x, y + k - offset) * dataKer[k];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageBorder_F32 input, GrayF32 output) {
        int j;
        int i;
        int indexKer;
        float total;
        int indexDest;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int offsetL = kernel.getOffset();
        int offsetR = kernel.getWidth() - offsetL - 1;
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int x;
            indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offsetL; ++x) {
                total = 0.0f;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - offsetR;
            for (x = width - offsetR; x < width; ++x) {
                total = 0.0f;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
        }
        for (int x = offsetL; x < width - offsetR; ++x) {
            indexDest = output.startIndex + x;
            int y = 0;
            while (y < offsetL) {
                total = 0.0f;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - offsetR) * output.stride + x;
            y = height - offsetR;
            while (y < height) {
                total = 0.0f;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, ImageBorder_S32 input, GrayI16 output) {
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = output.getWidth();
        int height = output.getHeight();
        int borderRight = kernelWidth - offset - 1;
        for (int y = 0; y < height; ++y) {
            int k;
            int total;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offset; ++x) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x + k - offset, y) * dataKer[k];
                }
                dataDst[indexDest++] = (short)total;
            }
            indexDest = output.startIndex + y * output.stride + width - borderRight;
            for (x = width - borderRight; x < width; ++x) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x + k - offset, y) * dataKer[k];
                }
                dataDst[indexDest++] = (short)total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, ImageBorder_S32 input, GrayI16 output) {
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = output.getWidth();
        int height = output.getHeight();
        int borderBottom = kernelWidth - offset - 1;
        for (int x = 0; x < width; ++x) {
            int k;
            int total;
            int indexDest = output.startIndex + x;
            int y = 0;
            while (y < offset) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x, y + k - offset) * dataKer[k];
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - borderBottom) * output.stride + x;
            y = height - borderBottom;
            while (y < height) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x, y + k - offset) * dataKer[k];
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, ImageBorder_S32 input, GrayI16 output) {
        int j;
        int i;
        int indexKer;
        int total;
        int indexDest;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offsetL = kernel.getOffset();
        int offsetR = kernel.getWidth() - offsetL - 1;
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int x;
            indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offsetL; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = (short)total;
            }
            indexDest = output.startIndex + y * output.stride + width - offsetR;
            for (x = width - offsetR; x < width; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = (short)total;
            }
        }
        for (int x = offsetL; x < width - offsetR; ++x) {
            indexDest = output.startIndex + x;
            int y = 0;
            while (y < offsetL) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - offsetR) * output.stride + x;
            y = height - offsetR;
            while (y < height) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = (short)total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, ImageBorder_S32 input, GrayS32 output) {
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = output.getWidth();
        int height = output.getHeight();
        int borderRight = kernelWidth - offset - 1;
        for (int y = 0; y < height; ++y) {
            int k;
            int total;
            int x;
            int indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offset; ++x) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x + k - offset, y) * dataKer[k];
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - borderRight;
            for (x = width - borderRight; x < width; ++x) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x + k - offset, y) * dataKer[k];
                }
                dataDst[indexDest++] = total;
            }
        }
    }

    public static void vertical(Kernel1D_S32 kernel, ImageBorder_S32 input, GrayS32 output) {
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offset = kernel.getOffset();
        int kernelWidth = kernel.getWidth();
        int width = output.getWidth();
        int height = output.getHeight();
        int borderBottom = kernelWidth - offset - 1;
        for (int x = 0; x < width; ++x) {
            int k;
            int total;
            int indexDest = output.startIndex + x;
            int y = 0;
            while (y < offset) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x, y + k - offset) * dataKer[k];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - borderBottom) * output.stride + x;
            y = height - borderBottom;
            while (y < height) {
                total = 0;
                for (k = 0; k < kernelWidth; ++k) {
                    total += input.get(x, y + k - offset) * dataKer[k];
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }

    public static void convolve(Kernel2D_S32 kernel, ImageBorder_S32 input, GrayS32 output) {
        int j;
        int i;
        int indexKer;
        int total;
        int indexDest;
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int offsetL = kernel.getOffset();
        int offsetR = kernel.getWidth() - offsetL - 1;
        int width = output.getWidth();
        int height = output.getHeight();
        for (int y = 0; y < height; ++y) {
            int x;
            indexDest = output.startIndex + y * output.stride;
            for (x = 0; x < offsetL; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
            indexDest = output.startIndex + y * output.stride + width - offsetR;
            for (x = width - offsetR; x < width; ++x) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest++] = total;
            }
        }
        for (int x = offsetL; x < width - offsetR; ++x) {
            indexDest = output.startIndex + x;
            int y = 0;
            while (y < offsetL) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
            indexDest = output.startIndex + (height - offsetR) * output.stride + x;
            y = height - offsetR;
            while (y < height) {
                total = 0;
                indexKer = 0;
                for (i = -offsetL; i <= offsetR; ++i) {
                    for (j = -offsetL; j <= offsetR; ++j) {
                        total += input.get(x + j, y + i) * dataKer[indexKer++];
                    }
                }
                dataDst[indexDest] = total;
                ++y;
                indexDest += output.stride;
            }
        }
    }
}

