/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.array;

import boofcv.alg.interpolate.array.Interpolate1D_F32;

public class PolynomialNeville_F32
extends Interpolate1D_F32 {
    private float[] c;
    private float[] d;

    public PolynomialNeville_F32(int maxDegree) {
        super(maxDegree);
        this.c = new float[this.M];
        this.d = new float[this.M];
    }

    public PolynomialNeville_F32(int maxDegree, float[] x, float[] y, int size) {
        super(maxDegree, x, y, size);
        this.c = new float[this.M];
        this.d = new float[this.M];
    }

    @Override
    protected float compute(float sample) {
        int i0 = this.index0;
        int closestIndex = 0;
        float smallestDiff = Math.abs(sample - this.x[i0]);
        for (int i = i0; i < i0 + this.M; ++i) {
            float diff = Math.abs(sample - this.x[i]);
            if (diff < smallestDiff) {
                closestIndex = i - i0;
                smallestDiff = diff;
            }
            this.c[i - i0] = this.y[i];
            this.d[i - i0] = this.y[i];
        }
        float estimate = this.y[i0 + closestIndex--];
        for (int m = 1; m < this.M; ++m) {
            for (int i = 0; i < this.M - m; ++i) {
                float ho = this.x[i0 + i] - sample;
                float hp = this.x[i0 + i + m] - sample;
                float w = this.c[i + 1] - this.d[i];
                float den = ho - hp;
                if ((double)den == 0.0) {
                    throw new RuntimeException("Two x's are identical");
                }
                den = w / den;
                this.d[i] = hp * den;
                this.c[i] = ho * den;
            }
            if (2 * (closestIndex + 1) < this.M - m) {
                estimate += this.c[closestIndex + 1];
                continue;
            }
            estimate += this.d[closestIndex];
            --closestIndex;
        }
        return estimate;
    }
}

